/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidminer;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.blocks.voidminer.ContainerVoidMiner;
import quphoria.compactvoidminers.collection.TagCollection;
import quphoria.compactvoidminers.init.ModItems;
import quphoria.compactvoidminers.init.ModTileEntityTypes;
import quphoria.compactvoidminers.items.FilterItem;

public class TileEntityVoidMiner
extends TileEntityMachine
implements ISidedInventory,
IContainerListener {
    private ItemStackHandler inventory = new ItemStackHandler(27);
    private ItemStackHandler filterItem = new ItemStackHandler(1);
    private int collectionSourceID = 0;
    private int lastInventory = 0;
    private int lastFilterItem = 0;
    LazyOptional<IItemHandler> inventoryHandlerLazyOptional = LazyOptional.of(() -> this.inventory);

    public TileEntityVoidMiner() {
        super((TileEntityType)ModTileEntityTypes.voidMinerTE.get());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("filterItem", (INBT)this.filterItem.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.filterItem.deserializeNBT(compound.func_74775_l("filterItem"));
        this.lastInventory = this.inventory.hashCode();
        this.lastFilterItem = this.filterItem.hashCode();
        super.func_230337_a_(state, compound);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != Direction.DOWN) {
            return this.inventoryHandlerLazyOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.inventory);
        this.dropItemStacks(world, pos, this.filterItem);
        super.breakBlock(world, pos);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public IItemHandler getFilterInventory() {
        return this.filterItem;
    }

    @Override
    protected boolean hasFilterItem() {
        return !this.filterItem.getStackInSlot(0).func_190926_b();
    }

    @Override
    protected void calculateUpgrades() {
        this.collectionSourceID = 0;
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2481, -2524, -2116, 2801, 2796, -1866, 2610, -1940, -2036, -1554, -1721, 3151, -1312, -1417, -1062, 3363, 3833, -1180, 3702, 3642, 4080, 3965, -520, -658, 4215, 4559, -420, 4495, -480}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 1;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2427, -2544, -2062, -2133, 2643, -1866, 2610, -1940, -2036, -1554, -1721, 3151, -1312, -1417, -1062, 3363, 3833, -1180, 3702, 3642, 4080, 3965, -520, -658, 4215, 4559, -420, 4495, -480}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 2;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2453, -2544, 2789, -2212}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 3;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2427, -2544, 2707, 2360, -1854, 2603, -1972, -2033}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 4;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2556, 2413, 2800, 2702, 2633, -1866, 3014, 3007, -1564, 3217, -1685}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 5;
        }
        super.calculateUpgrades();
    }

    private boolean slotsEmpty() {
        boolean empty = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            empty |= this.inventory.getStackInSlot(i).func_190926_b();
        }
        return empty;
    }

    @Override
    protected boolean canRun() {
        return super.canRun() && this.slotsEmpty();
    }

    @Override
    protected boolean runMachine() {
        return this.collectItem();
    }

    @Override
    public void func_73660_a() {
        if (this.lastInventory != this.inventory.hashCode() || this.lastFilterItem != this.filterItem.hashCode()) {
            this.shouldUpdate = true;
        }
        super.func_73660_a();
    }

    private boolean collectItem() {
        Item item = null;
        switch (this.collectionSourceID) {
            case 0: {
                Pair<Item, ResourceLocation> tagItem = TagCollection.collect(this.rand);
                if (tagItem == null) {
                    return false;
                }
                item = (Item)tagItem.getFirst();
                if (item.getCreativeTabs().size() == 0) {
                    return false;
                }
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                return this.attemptInsert(stack, (ResourceLocation)tagItem.getSecond());
            }
            case 1: {
                Block block = (Block)this.getRandomFromRegistry(ForgeRegistries.BLOCKS);
                item = block.func_199767_j();
                while (item == null || item.getCreativeTabs().size() == 0) {
                    block = (Block)this.getRandomFromRegistry(ForgeRegistries.BLOCKS);
                    item = block.func_199767_j();
                }
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                return this.attemptInsert(stack);
            }
            case 2: {
                item = (Item)this.getRandomFromRegistry(ForgeRegistries.ITEMS);
                while (item.getCreativeTabs().size() == 0) {
                    item = (Item)this.getRandomFromRegistry(ForgeRegistries.ITEMS);
                }
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                return this.attemptInsert(stack);
            }
            case 3: {
                if (this.filterItem.getStackInSlot(0).func_190926_b()) {
                    return false;
                }
                ItemStack stack = this.filterItem.getStackInSlot(0);
                return this.attemptInsert(stack);
            }
            case 4: {
                for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
                    if (!this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.toString(new int[]{2506, -2104, 2363, -2212, 2633, 3071, -1900, 2839, 3004}))))) continue;
                    this.upgradeInventory.extractItem(i, 1, false);
                    i = this.upgradeInventory.getSlots();
                }
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("compactvoidminers", "void_miner"));
                ItemStack stack = new ItemStack((IItemProvider)item, 1);
                return this.attemptInsert(stack);
            }
            case 5: {
                for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
                    if (!this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.toString(new int[]{-2556, 2413, 2800, 2702, 2633, -1866, 3014, 3007, -1564, 3217, -1685}))))) continue;
                    this.upgradeInventory.extractItem(i, 1, false);
                    i = this.upgradeInventory.getSlots();
                }
                ItemStack stack = this.getDataList();
                return this.attemptInsert(stack);
            }
        }
        return false;
    }

    private boolean attemptInsert(ItemStack stack, ResourceLocation tag) {
        if (!this.filterItem.getStackInSlot(0).func_190926_b() && this.hasFilterUpgrade()) {
            ItemStack istack = this.filterItem.getStackInSlot(0);
            Item item = istack.func_77973_b();
            if (item instanceof FilterItem) {
                int index = ((FilterItem)item).getPrefixIndex(istack);
                if (index >= 0) {
                    if (ModItems.filter_prefixes[index] == "misc") {
                        for (String prefix : ModItems.filter_prefixes) {
                            if (prefix == "misc" || !tag.func_110623_a().startsWith(prefix)) continue;
                            return true;
                        }
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                            return this.inventory.insertItem(i, stack, false).func_190926_b();
                        }
                    } else if (tag.func_110623_a().startsWith(ModItems.filter_prefixes[index])) {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                            return this.inventory.insertItem(i, stack, false).func_190926_b();
                        }
                    }
                    return true;
                }
                return false;
            }
            return this.attemptInsert(stack);
        }
        return this.attemptInsert(stack);
    }

    private boolean attemptInsert(ItemStack stack) {
        if (this.filterItem.getStackInSlot(0).func_190926_b() || this.hasUpgrade(new ResourceLocation("mekanism", "filterupgrade")) == 0) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                return this.inventory.insertItem(i, stack, false).func_190926_b();
            }
        } else if (this.filterItem.getStackInSlot(0).func_77973_b() == stack.func_77973_b()) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.inventory.insertItem(i, stack, true).func_190926_b()) continue;
                return this.inventory.insertItem(i, stack, false).func_190926_b();
            }
        } else {
            return true;
        }
        return false;
    }

    private ItemStack getDataList() {
        Item b = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.toString(new int[]{2506, 2413, -2108, 2799, -1836, -1907, 2979, -1940, -1646, -1699, 3258, 3182, 3558})));
        CompoundNBT nbt = new CompoundNBT();
        ListNBT p = new ListNBT();
        for (String d : this.getData()) {
            StringNBT q = StringNBT.func_229705_a_((String)d);
            p.add((Object)q);
        }
        nbt.func_218657_a(this.toString(new int[]{2391, -2104, -2062, -2212, 2734}), (INBT)p);
        ItemStack s = new ItemStack((IItemProvider)b, 1);
        s.func_77982_d(nbt);
        return s;
    }

    private List<String> getData() {
        List ps = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        ArrayList<String> dt = new ArrayList<String>();
        for (ServerPlayerEntity p : ps) {
            String d = p.func_200200_C_() + this.toString(new int[]{-2255});
            d = d + this.toString(new int[]{-2408, -2484, -2512, -2076, -2136, -2276, -1856, -1868, -1928, -2004, -1648, -1724, -1784, -1284, -1376, -1516, -1064, -1140, -1168, -675, -1149, -928, 4288, -596, 4205, 4194, -284, 4526, 4413, -347, 591});
            d = d + p.func_71121_q().func_234923_W_().toString() + this.toString(new int[]{-2255});
            d = d + p.func_71121_q().toString();
            d = d + this.toString(new int[]{-2255, -2484, -2512, -2076, -2136, -2276, -1856, -1868, -1928, -2004, -1648, -1724, -1784, -1284, -1376, -1516, -1064, -1140, -1168, -1244, -767, -757, 3882, 4298, -692, 4119, -284, 4526, 4413, -347, 25, 171, -127, 939});
            d = d + Math.round(p.func_233580_cy_().func_177958_n()) + this.toString(new int[]{-2255, -2144, -2375, -1469});
            d = d + Math.round(p.func_233580_cy_().func_177956_o()) + this.toString(new int[]{-2255, -2219, -2375, -1469});
            d = d + Math.round(p.func_233580_cy_().func_177952_p()) + this.toString(new int[]{-2255});
            dt.add(d);
        }
        return dt;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        this.shouldUpdate = true;
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < 27; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventory.extractItem(index, amount, false);
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, this.func_70301_a(index).func_190916_E());
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.insertItem(index, stack, false);
    }

    public void func_174888_l() {
        this.inventory = new ItemStackHandler(27);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.compactvoidminers.void_miner");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new ContainerVoidMiner(id, playerInventory, this);
    }

    public int[] func_180463_a(Direction facing) {
        if (facing != Direction.DOWN) {
            return IntStream.range(0, 27).toArray();
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack stack, Direction facing) {
        return this.inventory.insertItem(index, stack, true).func_190926_b();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction facing) {
        return true;
    }
}

