/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.blocks.TileEntityMachine;

public abstract class ContainerMachine<T extends TileEntityMachine>
extends Container {
    public T tileEntity;

    public ContainerMachine(ContainerType<?> type, int id, T tile) {
        super(type, id);
        this.tileEntity = tile;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return ((TileEntityMachine)((Object)this.tileEntity)).func_70300_a(player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public static boolean isBlockLoaded(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        if (world instanceof IWorldReader) {
            boolean haschunk = ((IWorldReader)world).func_175667_e(pos);
            return haschunk;
        }
        return true;
    }

    @Nonnull
    public static <T extends TileEntityMachine> T getTileFromBuf(PacketBuffer buf, ClientWorld world2, Class<T> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        return (T)((Object)((TileEntityMachine)((Object)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = buf.func_179259_c();
            if (!ContainerMachine.isBlockLoaded((IBlockReader)world, pos)) {
                throw new IllegalStateException("Client could not locate tile at " + pos + " for tile container. This is likely caused by a mod breaking client side tile lookup");
            }
            TileEntity tile = world.func_175625_s(pos);
            if (type.isInstance(tile)) {
                return (TileEntityMachine)((Object)((Object)((Object)type.cast(tile))));
            }
            CompactVoidMiners.LOGGER.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, (Object)type, tile.getClass());
            return null;
        }))));
    }
}

