/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public final class CopyScheduler
extends SteppedScheduler {
    private final BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher;
    private final Spliterator<PlacementTarget> targets;
    private final ImmutableMap.Builder<BlockPos, BlockData> builder;
    private Region.Builder regionBuilder;
    private final BuildContext context;

    public static void scheduleCopy(BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        ServerTickingScheduler.runTicked(new CopyScheduler(Objects.requireNonNull(finisher), Objects.requireNonNull(worldView), steps));
    }

    private CopyScheduler(BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        super(steps);
        this.finisher = finisher;
        this.targets = worldView.spliterator();
        this.builder = ImmutableMap.builder();
        this.context = worldView.getContext();
        this.regionBuilder = null;
    }

    @Override
    protected SteppedScheduler.StepResult advance() {
        return SteppedScheduler.StepResult.ofBoolean(this.targets.tryAdvance(t -> {
            if (!t.getData().getState().isAir((IBlockReader)this.context.getWorld(), t.getPos()) && ((GadgetCopyPaste)OurItems.COPY_PASTE_GADGET_ITEM.get()).isAllowedBlock(t.getData().getState().func_177230_c())) {
                this.builder.put((Object)t.getPos(), (Object)t.getData());
                if (this.regionBuilder == null) {
                    this.regionBuilder = Region.enclosingBuilder();
                }
                this.regionBuilder.enclose((Vector3i)t.getPos());
            }
        }));
    }

    @Override
    protected void onFinish() {
        this.finisher.accept((ImmutableMap<BlockPos, BlockData>)this.builder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
    }
}

