/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockMyrmexBiolight;
import com.github.alexthe666.iceandfire.block.BlockMyrmexConnectedResin;
import com.github.alexthe666.iceandfire.block.BlockMyrmexResin;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexDecoration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenMyrmexHive
extends Feature<NoFeatureConfig> {
    private static final BlockState DESERT_RESIN = IafBlockRegistry.MYRMEX_DESERT_RESIN.func_176223_P();
    private static final BlockState STICKY_DESERT_RESIN = IafBlockRegistry.MYRMEX_DESERT_RESIN_STICKY.func_176223_P();
    private static final BlockState JUNGLE_RESIN = IafBlockRegistry.MYRMEX_JUNGLE_RESIN.func_176223_P();
    private static final BlockState STICKY_JUNGLE_RESIN = IafBlockRegistry.MYRMEX_JUNGLE_RESIN_STICKY.func_176223_P();
    public MyrmexHive hive;
    private int entrances = 0;
    private int totalRooms;
    private boolean hasFoodRoom;
    private boolean hasNursery;
    private boolean small;
    private boolean jungle;
    private BlockPos centerOfHive;

    public WorldGenMyrmexHive(boolean small, boolean jungle, Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
        this.small = small;
        this.jungle = jungle;
    }

    public boolean placeSmallGen(ISeedReader worldIn, Random rand, BlockPos pos) {
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        this.entrances = 0;
        this.centerOfHive = pos;
        this.generateMainRoom((IServerWorld)worldIn, rand, pos);
        this.small = false;
        return false;
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos pos, NoFeatureConfig p_230362_6_) {
        if (!this.small) {
            if (!IafWorldRegistry.isDimensionListedForFeatures((IServerWorld)worldIn)) {
                return false;
            }
            if (!(IafConfig.generateMyrmexColonies && rand.nextInt(IafConfig.myrmexColonyGenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, pos) && IafWorldRegistry.isFarEnoughFromDangerousGen((IServerWorld)worldIn, pos))) {
                return false;
            }
            if (MyrmexWorldData.get((World)worldIn.func_201672_e()) != null && MyrmexWorldData.get((World)worldIn.func_201672_e()).getNearestHive(pos, 200) != null) {
                return false;
            }
        }
        pos = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos);
        if (!this.small && !worldIn.func_204610_c(pos.func_177977_b()).func_206888_e()) {
            return false;
        }
        this.hasFoodRoom = false;
        this.hasNursery = false;
        this.totalRooms = 0;
        int down = Math.max(15, pos.func_177956_o() - 20 + rand.nextInt(10));
        BlockPos undergroundPos = new BlockPos(pos.func_177958_n(), down, pos.func_177952_p());
        this.entrances = 0;
        this.centerOfHive = undergroundPos;
        this.generateMainRoom((IServerWorld)worldIn, rand, undergroundPos);
        this.small = false;
        return false;
    }

    private void generateMainRoom(IServerWorld world, Random rand, BlockPos position) {
        this.hive = new MyrmexHive((World)world.func_201672_e(), position, 100);
        MyrmexWorldData.addHive((World)world.func_201672_e(), this.hive);
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphere((IWorld)world, rand, position, 14, 7, resin, sticky_resin);
        this.generateSphere((IWorld)world, rand, position, 12, 5, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere((IWorld)world, rand, position, 12, 5, RoomType.QUEEN);
        this.generatePath((IWorld)world, rand, position.func_177967_a(Direction.NORTH, 9).func_177977_b(), 15 + rand.nextInt(10), Direction.NORTH, 100);
        this.generatePath((IWorld)world, rand, position.func_177967_a(Direction.SOUTH, 9).func_177977_b(), 15 + rand.nextInt(10), Direction.SOUTH, 100);
        this.generatePath((IWorld)world, rand, position.func_177967_a(Direction.WEST, 9).func_177977_b(), 15 + rand.nextInt(10), Direction.WEST, 100);
        this.generatePath((IWorld)world, rand, position.func_177967_a(Direction.EAST, 9).func_177977_b(), 15 + rand.nextInt(10), Direction.EAST, 100);
        if (!this.small) {
            EntityMyrmexBase myrmex;
            int i;
            EntityMyrmexQueen queen = new EntityMyrmexQueen((EntityType<EntityMyrmexQueen>)((EntityType)IafEntityRegistry.MYRMEX_QUEEN.get()), (World)world.func_201672_e());
            BlockPos ground = MyrmexHive.getGroundedPos((IWorld)world, position);
            queen.func_213386_a(world, world.func_175649_E(ground), SpawnReason.CHUNK_GENERATION, null, null);
            queen.setHive(this.hive);
            queen.setJungleVariant(this.jungle);
            queen.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_217376_c((Entity)queen);
            for (i = 0; i < 4 + rand.nextInt(3); ++i) {
                myrmex = new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntityRegistry.MYRMEX_WORKER.get()), (World)world.func_201672_e());
                myrmex.func_213386_a(world, world.func_175649_E(ground), SpawnReason.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.func_217376_c((Entity)myrmex);
            }
            for (i = 0; i < 2 + rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSoldier((EntityType<EntityMyrmexSoldier>)((EntityType)IafEntityRegistry.MYRMEX_SOLDIER.get()), (World)world.func_201672_e());
                myrmex.func_213386_a(world, world.func_175649_E(ground), SpawnReason.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.func_217376_c((Entity)myrmex);
            }
            for (i = 0; i < rand.nextInt(2); ++i) {
                myrmex = new EntityMyrmexSentinel((EntityType)IafEntityRegistry.MYRMEX_SENTINEL.get(), (World)world.func_201672_e());
                myrmex.func_213386_a(world, world.func_175649_E(ground), SpawnReason.CHUNK_GENERATION, null, null);
                myrmex.setHive(this.hive);
                myrmex.func_70080_a((double)ground.func_177958_n() + 0.5, (double)ground.func_177956_o() + 1.0, (double)ground.func_177952_p() + 0.5, 0.0f, 0.0f);
                myrmex.setJungleVariant(this.jungle);
                world.func_217376_c((Entity)myrmex);
            }
        }
    }

    private void generatePath(IWorld world, Random rand, BlockPos offset, int length, Direction direction, int roomChance) {
        if (roomChance == 0) {
            return;
        }
        if (this.small) {
            length /= 2;
            if (this.entrances < 1) {
                for (int i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.func_177967_a(direction, i), 3, 5, direction);
                }
                this.generateEntrance(world, rand, offset.func_177967_a(direction, length), 4, 4, direction);
            } else if (this.totalRooms < 2) {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.func_177967_a(direction, i), 3, 5, direction);
                }
                this.generateRoom(world, rand, offset.func_177967_a(direction, length), 6, 4, roomChance / 2, direction);
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.func_177967_a(direction, i), 3, 5, direction);
                    this.generateCircleAir(world, rand, offset.func_177967_a(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
            }
        } else if (rand.nextInt(100) < roomChance) {
            if (this.entrances < 3 && rand.nextInt(1 + this.entrances * 2) == 0 && this.hasFoodRoom && this.hasNursery && this.totalRooms > 3 || this.entrances == 0) {
                this.generateEntrance(world, rand, offset.func_177967_a(direction, 1), 4, 4, direction);
            } else {
                int i;
                for (i = 0; i < length; ++i) {
                    this.generateCircle(world, rand, offset.func_177967_a(direction, i), 3, 5, direction);
                }
                for (i = -3; i < 3; ++i) {
                    this.generateCircleAir(world, rand, offset.func_177967_a(direction, length + i), 3, 5, direction);
                }
                ++this.totalRooms;
                this.generateRoom(world, rand, offset.func_177967_a(direction, length), 7, 4, roomChance / 2, direction);
            }
        }
    }

    private void generateRoom(IWorld world, Random rand, BlockPos position, int size, int height, int roomChance, Direction direction) {
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        RoomType type = RoomType.random(rand);
        if (!this.hasFoodRoom) {
            type = RoomType.FOOD;
            this.hasFoodRoom = true;
        } else if (!this.hasNursery) {
            type = RoomType.NURSERY;
            this.hasNursery = true;
        }
        this.generateSphereRespectResin(world, rand, position, size + 2, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, position, size, height - 1, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere(world, rand, position, size, height - 1, type);
        this.hive.addRoom(position, type);
        if (!this.small) {
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != Direction.NORTH) {
                this.generatePath(world, rand, position.func_177967_a(Direction.NORTH, size - 2), 5 + rand.nextInt(20), Direction.NORTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != Direction.SOUTH) {
                this.generatePath(world, rand, position.func_177967_a(Direction.SOUTH, size - 2), 5 + rand.nextInt(20), Direction.SOUTH, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != Direction.WEST) {
                this.generatePath(world, rand, position.func_177967_a(Direction.WEST, size - 2), 5 + rand.nextInt(20), Direction.WEST, roomChance);
            }
            if (rand.nextInt(3) == 0 && direction.func_176734_d() != Direction.EAST) {
                this.generatePath(world, rand, position.func_177967_a(Direction.EAST, size - 2), 5 + rand.nextInt(20), Direction.EAST, roomChance);
            }
        }
    }

    private void generateEntrance(IWorld world, Random rand, BlockPos position, int size, int height, Direction direction) {
        BlockPos up = position.func_177984_a();
        this.hive.getEntranceBottoms().put(up, direction);
        while (up.func_177956_o() < world.func_205770_a(this.small ? Heightmap.Type.MOTION_BLOCKING_NO_LEAVES : Heightmap.Type.WORLD_SURFACE_WG, up).func_177956_o() && !BlockTags.field_200031_h.func_230235_a_((Object)world.func_180495_p(up).func_177230_c())) {
            this.generateCircleRespectSky(world, rand, up, size, height, direction);
            up = up.func_177984_a().func_177972_a(direction);
        }
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        this.generateSphereRespectAir(world, rand, up, size + 4, height + 2, resin, sticky_resin);
        this.generateSphere(world, rand, up.func_177984_a(), size, height, Blocks.field_150350_a.func_176223_P());
        this.decorateSphere(world, rand, up.func_177984_a(), size, height - 1, RoomType.ENTERANCE);
        this.hive.getEntrances().put(up, direction);
        ++this.entrances;
    }

    private void generateCircle(IWorld world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int z;
        int x;
        float j;
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i);
                z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.func_180501_a(position.func_177982_a(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin, 2);
                } else {
                    world.func_180501_a(position.func_177982_a(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin, 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.func_180501_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P(), 2);
                } else {
                    world.func_180501_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P(), 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    private void generateCircleRespectSky(IWorld world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int z;
        int x;
        float j;
        BlockState resin = this.jungle ? JUNGLE_RESIN : DESERT_RESIN;
        BlockState sticky_resin = this.jungle ? STICKY_JUNGLE_RESIN : STICKY_DESERT_RESIN;
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i);
                z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    if (!world.func_175710_j(position.func_177982_a(0, x, z))) {
                        world.func_180501_a(position.func_177982_a(0, x, z), rand.nextInt(3) == 0 ? sticky_resin : resin, 3);
                    }
                } else if (!world.func_175710_j(position.func_177982_a(x, z, 0))) {
                    world.func_180501_a(position.func_177982_a(x, z, 0), rand.nextInt(3) == 0 ? sticky_resin : resin, 3);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        radius -= 2;
        i = 0.0f;
        while (i < (float)radius) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.func_180501_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P(), 3);
                } else {
                    world.func_180501_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P(), 3);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    private void generateCircleAir(IWorld world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int radius = size;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                int z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.5f, (float)1.0f));
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    world.func_180501_a(position.func_177982_a(0, x, z), Blocks.field_150350_a.func_176223_P(), 2);
                } else {
                    world.func_180501_a(position.func_177982_a(x, z, 0), Blocks.field_150350_a.func_176223_P(), 2);
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        this.decorateCircle(world, rand, position, size, height, direction);
    }

    public void generateSphere(IWorld world, Random rand, BlockPos position, int size, int height, BlockState fill) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos)) continue;
            world.func_180501_a(blockpos, fill, 3);
        }
    }

    public void generateSphere(IWorld world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f)))) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectResin(IWorld world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos) && (!world.func_175623_d(blockpos) || this.hasResinUnder(blockpos, world))) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    public void generateSphereRespectAir(IWorld world, Random rand, BlockPos position, int size, int height, BlockState fill, BlockState fill2) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || world.func_175623_d(blockpos)) continue;
            world.func_180501_a(blockpos, rand.nextInt(3) == 0 ? fill2 : fill, 2);
        }
    }

    private boolean hasResinUnder(BlockPos pos, IWorld world) {
        BlockPos copy = pos.func_177977_b();
        while (world.func_175623_d(copy) && copy.func_177956_o() > 1) {
            copy = copy.func_177977_b();
        }
        return world.func_180495_p(copy).func_177230_c() instanceof BlockMyrmexResin || world.func_180495_p(copy).func_177230_c() instanceof BlockMyrmexConnectedResin;
    }

    private void decorateCircle(IWorld world, Random rand, BlockPos position, int size, int height, Direction direction) {
        int radius = size + 2;
        float i = 0.0f;
        while (i < (float)radius) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                int x = (int)Math.floor(MathHelper.func_76126_a((float)j) * i);
                int z = (int)Math.floor(MathHelper.func_76134_b((float)j) * i);
                if (direction == Direction.WEST || direction == Direction.EAST) {
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorate(world, position.func_177982_a(0, x, z), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorateTubers(world, position.func_177982_a(0, x, z), rand, RoomType.TUNNEL);
                    }
                } else {
                    if (world.func_175623_d(position.func_177982_a(x, z, 0))) {
                        this.decorate(world, position.func_177982_a(x, z, 0), position, size, rand, RoomType.TUNNEL);
                    }
                    if (world.func_175623_d(position.func_177982_a(0, x, z))) {
                        this.decorateTubers(world, position.func_177982_a(0, x, z), rand, RoomType.TUNNEL);
                    }
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }

    private void decorateSphere(IWorld world, Random rand, BlockPos position, int size, int height, RoomType roomType) {
        int i2 = size;
        int ySize = rand.nextInt(2);
        int j = i2 + rand.nextInt(2);
        int k = height + ySize;
        int l = i2 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k + 1, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f))) continue;
            if (world.func_180495_p(blockpos.func_177977_b()).func_200132_m() && world.func_175623_d(blockpos)) {
                this.decorate(world, blockpos, position, size, rand, roomType);
            }
            if (!world.func_175623_d(blockpos)) continue;
            this.decorateTubers(world, blockpos, rand, roomType);
        }
    }

    private void decorate(IWorld world, BlockPos blockpos, BlockPos center, int size, Random random, RoomType roomType) {
        switch (roomType) {
            case FOOD: {
                if (random.nextInt(45) == 0 && world.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof BlockMyrmexResin) {
                    WorldGenMyrmexDecoration.generateSkeleton(world, blockpos, center, size, random);
                }
                if (random.nextInt(13) == 0) {
                    WorldGenMyrmexDecoration.generateLeaves(world, blockpos, center, size, random, this.jungle);
                }
                if (random.nextInt(12) == 0) {
                    WorldGenMyrmexDecoration.generatePumpkins(world, blockpos, center, size, random, this.jungle);
                }
                if (random.nextInt(6) == 0) {
                    WorldGenMyrmexDecoration.generateMushrooms(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, this.jungle ? WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST : WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
                break;
            }
            case NURSERY: {
                break;
            }
            case SHINY: {
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateGold(world, blockpos, center, size, random);
                break;
            }
            case TRASH: {
                if (random.nextInt(24) == 0) {
                    WorldGenMyrmexDecoration.generateTrashHeap(world, blockpos, center, size, random);
                }
                if (random.nextBoolean()) {
                    WorldGenMyrmexDecoration.generateTrashOre(world, blockpos, center, size, random);
                }
                if (random.nextInt(12) != 0) break;
                WorldGenMyrmexDecoration.generateCocoon(world, blockpos, random, this.jungle, WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
                break;
            }
        }
    }

    private void decorateTubers(IWorld world, BlockPos blockpos, Random random, RoomType roomType) {
        if (world.func_180495_p(blockpos.func_177984_a()).func_200132_m() && random.nextInt(roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 20 : 6) == 0) {
            int tuberLength = roomType == RoomType.ENTERANCE || roomType == RoomType.TUNNEL ? 1 : (roomType == RoomType.QUEEN ? 1 + random.nextInt(5) : 1 + random.nextInt(3));
            for (int i = 0; i < tuberLength; ++i) {
                if (!world.func_175623_d(blockpos.func_177979_c(i))) continue;
                boolean connected = i != tuberLength - 1;
                world.func_180501_a(blockpos.func_177979_c(i), this.jungle ? (BlockState)IafBlockRegistry.MYRMEX_JUNGLE_BIOLIGHT.func_176223_P().func_206870_a((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)) : (BlockState)IafBlockRegistry.MYRMEX_DESERT_BIOLIGHT.func_176223_P().func_206870_a((Property)BlockMyrmexBiolight.CONNECTED_DOWN, (Comparable)Boolean.valueOf(connected)), 2);
            }
        }
    }

    public static enum RoomType {
        DEFAULT(false),
        TUNNEL(false),
        ENTERANCE(false),
        QUEEN(false),
        FOOD(true),
        EMPTY(true),
        NURSERY(true),
        SHINY(true),
        TRASH(true);

        boolean random;

        private RoomType(boolean random) {
            this.random = random;
        }

        public static RoomType random(Random rand) {
            ArrayList<RoomType> list = new ArrayList<RoomType>();
            for (RoomType type : RoomType.values()) {
                if (!type.random) continue;
                list.add(type);
            }
            return (RoomType)((Object)list.get(rand.nextInt(list.size())));
        }
    }
}

