/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.message.MessageMultipartInteract;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityMutlipartPart
extends Entity {
    private static final DataParameter<Optional<UUID>> PARENT_UUID = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Float> SCALE_WIDTH = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SCALE_HEIGHT = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PART_YAW = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    public EntitySize multipartSize;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier;

    protected EntityMutlipartPart(EntityType<?> t, World world) {
        super(t, world);
        this.multipartSize = t.func_220334_j();
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public Entity getEntity() {
        return this;
    }

    protected void func_71061_d_() {
    }

    public EntityMutlipartPart(EntityType<?> t, Entity parent, float radius, float angleYaw, float offsetY, float sizeX, float sizeY, float damageMultiplier) {
        super(t, parent.field_70170_p);
        this.setParent(parent);
        this.setScaleX(sizeX);
        this.setScaleY(sizeY);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.damageMultiplier = damageMultiplier;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.1);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(this.getScaleX(), this.getScaleY(), false);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PARENT_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(SCALE_WIDTH, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(SCALE_HEIGHT, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(PART_YAW, (Object)Float.valueOf(0.0f));
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.field_70180_af.func_187225_a(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    private float getScaleX() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE_WIDTH)).floatValue();
    }

    private void setScaleX(float scale) {
        this.field_70180_af.func_187227_b(SCALE_WIDTH, (Object)Float.valueOf(scale));
    }

    private float getScaleY() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE_HEIGHT)).floatValue();
    }

    private void setScaleY(float scale) {
        this.field_70180_af.func_187227_b(SCALE_HEIGHT, (Object)Float.valueOf(scale));
    }

    public float getPartYaw() {
        return ((Float)this.field_70180_af.func_187225_a(PART_YAW)).floatValue();
    }

    private void setPartYaw(float yaw) {
        this.field_70180_af.func_187227_b(PART_YAW, (Object)Float.valueOf(yaw % 360.0f));
    }

    public void func_70071_h_() {
        this.field_70171_ac = false;
        if (this.field_70173_aa > 10) {
            Entity parent = this.getParent();
            this.func_213323_x_();
            if (parent != null && !this.field_70170_p.field_72995_K) {
                float renderYawOffset = parent.field_70177_z;
                if (parent instanceof LivingEntity) {
                    renderYawOffset = ((LivingEntity)parent).field_70761_aq;
                }
                if (this.isSlowFollow()) {
                    this.func_70107_b(parent.field_70169_q + (double)(this.radius * MathHelper.func_76134_b((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.field_70167_r + (double)this.offsetY, parent.field_70166_s + (double)(this.radius * MathHelper.func_76126_a((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    double d0 = parent.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = parent.func_226278_cu_() - this.func_226278_cu_();
                    double d2 = parent.func_226281_cx_() - this.func_226281_cx_();
                    MathHelper.func_181159_b((double)d2, (double)d0);
                    float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                    this.field_70125_A = this.limitAngle(this.field_70125_A, f2, 5.0f);
                    this.func_70018_K();
                    this.field_70177_z = renderYawOffset;
                    this.setPartYaw(this.field_70177_z);
                    if (!this.field_70170_p.field_72995_K) {
                        this.collideWithNearbyEntities();
                    }
                } else {
                    this.func_70107_b(parent.func_226277_ct_() + (double)(this.radius * MathHelper.func_76134_b((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))), parent.func_226278_cu_() + (double)this.offsetY, parent.func_226281_cx_() + (double)(this.radius * MathHelper.func_76126_a((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)this.angleYaw)))));
                    this.func_70018_K();
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.collideWithNearbyEntities();
                }
                if (parent.field_70128_L && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else if (this.field_70173_aa > 20 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    protected boolean isSlowFollow() {
        return false;
    }

    protected float limitAngle(float sourceAngle, float targetAngle, float maximumChange) {
        float f1;
        float f = MathHelper.func_76142_g((float)(targetAngle - sourceAngle));
        if (f > maximumChange) {
            f = maximumChange;
        }
        if (f < -maximumChange) {
            f = -maximumChange;
        }
        if ((f1 = sourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public void func_70106_y() {
        this.remove(false);
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.func_110124_au());
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean func_70067_L() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public void collideWithNearbyEntities() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && !EntityMutlipartPart.sharesRider(parent, entity) && !(entity instanceof EntityMutlipartPart) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f(parent));
        }
    }

    public static boolean sharesRider(Entity parent, Entity entityIn) {
        for (Entity entity : parent.func_184188_bt()) {
            if (entity.equals((Object)entityIn)) {
                return true;
            }
            if (!EntityMutlipartPart.sharesRider(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        Entity parent = this.getParent();
        if (this.field_70170_p.field_72995_K && parent != null) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageMultipartInteract(parent.func_145782_y(), 0.0f));
        }
        return parent != null ? parent.func_184230_a(player, hand) : ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity parent = this.getParent();
        if (this.field_70170_p.field_72995_K && source.func_76346_g() instanceof PlayerEntity && parent != null) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageMultipartInteract(parent.func_145782_y(), damage * this.damageMultiplier));
        }
        return parent != null && parent.func_70097_a(source, damage * this.damageMultiplier);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source.func_76347_k() || super.func_180431_b(source);
    }

    public boolean shouldNotExist() {
        Entity parent = this.getParent();
        return !parent.func_70089_S();
    }

    public boolean shouldContinuePersisting() {
        return this.isAddedToWorld() || this.field_70128_L;
    }
}

