/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderFrozenState {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("textures/block/frosted_ice_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("textures/block/frosted_ice_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("textures/block/frosted_ice_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("textures/block/frosted_ice_3.png");

    public static void render(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int light) {
        float sideExpand = -0.125f;
        float sideExpandY = 0.325f;
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)(-entity.func_213311_cf() / 2.0f - sideExpand), 0.0, (double)(-entity.func_213311_cf() / 2.0f - sideExpand), (double)(entity.func_213311_cf() / 2.0f + sideExpand), (double)(entity.func_213302_cg() + sideExpandY), (double)(entity.func_213311_cf() / 2.0f + sideExpand));
        matrixStack.func_227860_a_();
        RenderFrozenState.renderMovingAABB(axisalignedbb1, matrixStack, bufferIn, entity, light, 255);
        matrixStack.func_227865_b_();
    }

    private static ResourceLocation getIceTexture(int ticksFrozen) {
        if (ticksFrozen < 100) {
            if (ticksFrozen < 50) {
                if (ticksFrozen < 20) {
                    return TEXTURE_3;
                }
                return TEXTURE_2;
            }
            return TEXTURE_1;
        }
        return TEXTURE_0;
    }

    public static void renderMovingAABB(AxisAlignedBB boundingBox, MatrixStack stack, IRenderTypeBuffer bufferIn, LivingEntity entity, int light, int alpha) {
        RenderType rendertype = IafRenderType.getIce(RenderFrozenState.getIceTexture(FrozenProperties.ticksUntilUnfrozen(entity)));
        IVertexBuilder vertexbuffer = bufferIn.getBuffer(rendertype);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float maxX = (float)boundingBox.field_72336_d * 0.425f;
        float minX = (float)boundingBox.field_72340_a * 0.425f;
        float maxY = (float)boundingBox.field_72337_e * 0.425f;
        float minY = (float)boundingBox.field_72338_b * 0.425f;
        float maxZ = (float)boundingBox.field_72334_f * 0.425f;
        float minZ = (float)boundingBox.field_72339_c * 0.425f;
        float maxU = maxZ - minZ;
        float maxV = maxY - minY;
        float minU = minZ - maxZ;
        float minV = minY - maxY;
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        maxU = maxX - minX;
        maxV = maxY - minY;
        minU = minX - maxX;
        minV = minY - maxY;
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        maxU = maxZ - minZ;
        maxV = maxX - minX;
        minU = minZ - maxZ;
        minV = minX - maxX;
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225586_a_(255, 255, 255, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
    }
}

