/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.schematic.Schematic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParsedSchematicObject {
    public Schematic schematic;
    public List<Pair<BlockPos, BlockState>> blocks;
    public List<Pair<BlockPos, Entity>> entities;
    public List<BlockPos> blockEntityPositions;
    public String parseMessageString;
    public boolean parsedCorrectly;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public ParsedSchematicObject(Schematic _schematic, List<Pair<BlockPos, BlockState>> _blocks, List<Pair<BlockPos, Entity>> _entities, List<BlockPos> _blockEntityPositions, String _parseMessageString, boolean _parsedCorrectly) {
        this.schematic = _schematic;
        this.blocks = _blocks;
        this.entities = _entities;
        this.blockEntityPositions = _blockEntityPositions;
        this.parseMessageString = _parseMessageString;
        this.parsedCorrectly = _parsedCorrectly;
        this.offsetX = _schematic.getOffsetX();
        this.offsetY = _schematic.getOffsetY();
        this.offsetZ = _schematic.getOffsetZ();
    }

    public void placeBlockEntitiesInWorld(World level) {
        List<CompoundNBT> compoundTags = this.schematic.getBlockEntities();
        int i = 0;
        for (Pair<BlockPos, TileEntity> pair : this.getBlockEntities(level)) {
            BlockPos pos = (BlockPos)pair.getFirst();
            CompoundNBT compoundTag = compoundTags.get(i);
            compoundTag.func_82580_o("Pos");
            compoundTag.func_74778_a("id", compoundTag.func_74779_i("Id"));
            TileEntity blockEntity = TileEntity.func_235657_b_((BlockState)level.func_180495_p(pos), (CompoundNBT)compoundTag);
            level.func_175690_a(pos, blockEntity);
            ++i;
        }
    }

    public List<Pair<BlockPos, TileEntity>> getBlockEntities(World level) {
        ArrayList<Pair<BlockPos, TileEntity>> blockEntities = new ArrayList<Pair<BlockPos, TileEntity>>();
        for (BlockPos pos : this.blockEntityPositions) {
            blockEntities.add((Pair<BlockPos, TileEntity>)new Pair((Object)pos, (Object)level.func_175625_s(pos)));
        }
        return blockEntities;
    }
}

