/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.plugin;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.plugin.ChiselsAndBitsPlugin;
import mod.chiselsandbits.api.plugin.IChiselsAndBitsPlugin;
import mod.chiselsandbits.api.plugin.IChiselsAndBitsPluginManager;
import mod.chiselsandbits.api.util.ClassUtils;
import mod.chiselsandbits.api.util.GroupingUtils;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public final class PluginManger
implements IChiselsAndBitsPluginManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AEQUIVALEO_PLUGIN_TYPE = Type.getType(ChiselsAndBitsPlugin.class);
    private static final PluginManger INSTANCE = new PluginManger();
    private ImmutableSet<IChiselsAndBitsPlugin> plugins = ImmutableSet.of();

    public static PluginManger getInstance() {
        return INSTANCE;
    }

    private PluginManger() {
    }

    @Override
    public ImmutableSet<IChiselsAndBitsPlugin> getPlugins() {
        return this.plugins;
    }

    public void run(Consumer<IChiselsAndBitsPlugin> callback) {
        this.getPlugins().forEach(callback);
    }

    public void detect() {
        ModList modList = ModList.get();
        ArrayList<IChiselsAndBitsPlugin> plugins = new ArrayList<IChiselsAndBitsPlugin>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IChiselsAndBitsPlugin plugin;
                ArrayList requiredMods;
                if (!AEQUIVALEO_PLUGIN_TYPE.equals((Object)data.getAnnotationType()) || (requiredMods = (ArrayList)data.getAnnotationData().get("requiredMods")) != null && requiredMods.size() > 0 && requiredMods.stream().anyMatch(modId -> !ModList.get().isLoaded(modId)) || (plugin = PluginManger.createPluginFrom(data.getMemberName())) == null) continue;
                plugins.add(plugin);
                LOGGER.info("Found and loaded ChiselsAndBits plugin: {}", (Object)plugin.getId());
            }
        }
        Collection<Collection<IChiselsAndBitsPlugin>> groupedByIds = GroupingUtils.groupByUsingSet(plugins, IChiselsAndBitsPlugin::getId);
        Collection idsWithDuplicates = groupedByIds.stream().filter(p -> p.size() > 1).map(p -> (IChiselsAndBitsPlugin)p.iterator().next()).map(IChiselsAndBitsPlugin::getId).collect(Collectors.toSet());
        if (idsWithDuplicates.size() > 0) {
            throw new RuntimeException(String.format("Can not load C&B there are multiple instances of the plugins: [%s]", String.join((CharSequence)", ", idsWithDuplicates)));
        }
        this.plugins = ImmutableSet.copyOf(plugins);
    }

    @Nullable
    private static IChiselsAndBitsPlugin createPluginFrom(String className) {
        return ClassUtils.createOrGetInstance(className, IChiselsAndBitsPlugin.class, ChiselsAndBitsPlugin.Instance.class, IChiselsAndBitsPlugin::getId);
    }
}

