/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search.suffixtree;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.IntSummaryStatistics;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mezz.jei.search.suffixtree.Edge;
import mezz.jei.util.SubString;

class Node<T> {
    private Collection<T> data;
    private Char2ObjectMap<Edge<T>> edges = Char2ObjectMaps.emptyMap();
    @Nullable
    private Node<T> suffix = null;

    Node() {
        this.data = Collections.emptyList();
    }

    public void getData(Set<T> results) {
        results.addAll(this.data);
        for (Edge edge : this.edges.values()) {
            Node<T> dest = edge.getDest();
            dest.getData(results);
        }
    }

    void addRef(T value) {
        if (this.contains(value)) {
            return;
        }
        this.addValue(value);
        Node<T> iter = this.suffix;
        while (iter != null && !iter.contains(value)) {
            iter.addValue(value);
            iter = iter.suffix;
        }
    }

    protected boolean contains(T value) {
        return this.data.contains(value);
    }

    void addEdge(Edge<T> edge) {
        char firstChar = edge.charAt(0);
        int size = this.edges.size();
        if (size == 0) {
            this.edges = Char2ObjectMaps.singleton((char)firstChar, edge);
        } else if (size == 1) {
            Char2ObjectOpenHashMap newEdges = new Char2ObjectOpenHashMap(this.edges);
            newEdges.put(firstChar, edge);
            this.edges = newEdges;
        } else {
            this.edges.put(firstChar, edge);
        }
    }

    @Nullable
    Edge<T> getEdge(char ch) {
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Edge<T> getEdge(SubString string) {
        if (string.isEmpty()) {
            return null;
        }
        char ch = string.charAt(0);
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Node<T> getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node<T> suffix) {
        this.suffix = suffix;
    }

    protected void addValue(T value) {
        if (this.data.size() == 0) {
            this.data = ImmutableList.of(value);
        } else if (this.data.size() == 1) {
            this.data = ImmutableList.of(this.data.iterator().next(), value);
        } else if (this.data.size() == 2) {
            ArrayList<T> newData = new ArrayList<T>(4);
            newData.addAll(this.data);
            newData.add(value);
            this.data = newData;
        } else if (this.data.size() == 16) {
            Set newData = Collections.newSetFromMap(new IdentityHashMap());
            newData.addAll(this.data);
            newData.add(value);
            this.data = newData;
        } else {
            this.data.add(value);
        }
    }

    public String toString() {
        return "Node: size:" + this.data.size() + " Edges: " + this.edges.toString();
    }

    public IntSummaryStatistics nodeSizeStats() {
        return this.nodeSizes().summaryStatistics();
    }

    private IntStream nodeSizes() {
        return IntStream.concat(IntStream.of(this.data.size()), this.edges.values().stream().flatMapToInt(e -> super.nodeSizes()));
    }

    public String nodeEdgeStats() {
        IntSummaryStatistics edgeCounts = this.nodeEdgeCounts().summaryStatistics();
        IntSummaryStatistics edgeLengths = this.nodeEdgeLengths().summaryStatistics();
        return "Edge counts: " + edgeCounts + "\nEdge lengths: " + edgeLengths;
    }

    private IntStream nodeEdgeCounts() {
        return IntStream.concat(IntStream.of(this.edges.size()), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeCounts));
    }

    private IntStream nodeEdgeLengths() {
        return IntStream.concat(this.edges.values().stream().mapToInt(SubString::length), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeLengths));
    }
}

