/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.lightoverlay.common.forge.LightOverlay;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ClothScreen {
    public static Screen getConfigScreenByCloth(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new TranslationTextComponent("key.lightoverlay.category"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.lightoverlay.general"));
        general.addEntry((AbstractConfigListEntry)eb.startTextDescription(ITextComponent.func_244388_a((String)("\u00a77" + I18n.func_135052_a((String)"description.lightoverlay.caching", (Object[])new Object[0])))).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.caching"), LightOverlay.caching).setDefaultValue(false).setSaveConsumer(bool -> {
            LightOverlay.caching = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.reach"), LightOverlay.reach, 1, 64).setDefaultValue(12).setTextGetter(integer -> ITextComponent.func_244388_a((String)("Reach: " + integer + " Blocks"))).setSaveConsumer(integer -> {
            LightOverlay.reach = integer;
        }).build());
        IntegerSliderEntry crossLevel = eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.crossLevel"), LightOverlay.crossLevel, 0, 15).setDefaultValue(7).setTextGetter(integer -> ITextComponent.func_244388_a((String)("Cross Level: " + integer))).setSaveConsumer(integer -> {
            LightOverlay.crossLevel = integer;
        }).build();
        general.addEntry((AbstractConfigListEntry)crossLevel);
        general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.secondaryLevel"), LightOverlay.secondaryLevel, -1, 15).setErrorSupplier(integer -> {
            if (integer >= 0 && integer >= crossLevel.getValue()) {
                return Optional.of(new StringTextComponent("Secondary Level cannot be higher than Cross Level!"));
            }
            return Optional.empty();
        }).setDefaultValue(-1).setTextGetter(integer -> new StringTextComponent(integer < 0 ? "Off" : "Level: " + integer)).setSaveConsumer(integer -> {
            LightOverlay.secondaryLevel = integer;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.showNumber"), LightOverlay.showNumber).setDefaultValue(false).setSaveConsumer(bool -> {
            LightOverlay.showNumber = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.smoothLines"), LightOverlay.smoothLines).setDefaultValue(true).setSaveConsumer(bool -> {
            LightOverlay.smoothLines = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.underwater"), LightOverlay.underwater).setDefaultValue(false).setSaveConsumer(bool -> {
            LightOverlay.underwater = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.mushroom"), LightOverlay.mushroom).setDefaultValue(false).setSaveConsumer(bool -> {
            LightOverlay.mushroom = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.lightoverlay.useListWhileCaching"), LightOverlay.useListWhileCaching).setDefaultValue(true).setSaveConsumer(bool -> {
            LightOverlay.useListWhileCaching = bool;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startIntSlider((ITextComponent)new TranslationTextComponent("config.lightoverlay.lineWidth"), MathHelper.func_76141_d((float)(LightOverlay.lineWidth * 100.0f)), 100, 700).setDefaultValue(100).setTextGetter(integer -> new StringTextComponent("Light Width: " + LightOverlay.FORMAT.format((double)integer.intValue() / 100.0))).setSaveConsumer(integer -> {
            LightOverlay.lineWidth = (float)integer.intValue() / 100.0f;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.yellowColor"), LightOverlay.yellowColor).setDefaultValue(0xFFFF00).setSaveConsumer(color -> {
            LightOverlay.yellowColor = color;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.redColor"), LightOverlay.redColor).setDefaultValue(0xFF0000).setSaveConsumer(color -> {
            LightOverlay.redColor = color;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startColorField((ITextComponent)new TranslationTextComponent("config.lightoverlay.secondaryColor"), LightOverlay.secondaryColor).setDefaultValue(255).setSaveConsumer(color -> {
            LightOverlay.secondaryColor = color;
        }).build());
        return builder.setSavingRunnable(() -> {
            try {
                LightOverlay.saveConfig(LightOverlay.configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LightOverlay.loadConfig(LightOverlay.configFile);
        }).build();
    }
}

