/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easy_villagers.corelib.block.IItemBlock;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.ModItemGroups;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.OutputContainer;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.items.render.FarmerItemRenderer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FarmerBlock
extends VillagerBlockBase
implements ITileEntityProvider,
IItemBlock {
    public FarmerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.setRegistryName(new ResourceLocation("easy_villagers", "farmer"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_EASY_VILLAGERS).setISTER(() -> FarmerItemRenderer::new)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(final BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof FarmerTileentity)) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        final FarmerTileentity farmer = (FarmerTileentity)tileEntity;
        if (!farmer.hasVillager() && heldItem.func_77973_b() instanceof VillagerItem) {
            farmer.setVillager(heldItem.func_77946_l());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_187915_go);
            return ActionResultType.SUCCESS;
        }
        if (farmer.getCrop() == null && farmer.isValidSeed(heldItem.func_77973_b())) {
            Item seed = heldItem.func_77973_b();
            farmer.setCrop(seed);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = farmer.getVillagerEntity();
            if (villagerEntity != null) {
                VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219698_mF);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219626_bz);
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && farmer.getCrop() != null) {
            ItemStack blockStack = new ItemStack((IItemProvider)farmer.removeSeed());
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, blockStack);
            } else if (!player.field_71071_by.func_70441_a(blockStack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)blockStack);
            }
            if (farmer.hasVillager()) {
                VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_187913_gm);
            }
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && farmer.hasVillager()) {
            ItemStack stack = farmer.removeVillager();
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, stack);
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219721_mv);
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(state.func_177230_c().func_149739_a());
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                return new OutputContainer(id, playerInventory, farmer.getOutputInventory());
            }
        });
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new FarmerTileentity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }
}

