/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.AutoBlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.AutoSmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.util.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class AutoCookingUpgradeWrapper<W extends AutoCookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends AbstractCookingRecipe>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final CookingLogic<R> cookingLogic;
    private final Predicate<ItemStack> isValidInput;
    private final Predicate<ItemStack> isValidFuel;
    private final IRecipeType<R> recipeType;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;

    public AutoCookingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler, Config.Common.AutoCookingUpgradeConfig autoCookingConfig, IRecipeType<R> recipeType, float burnTimeModifier) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.recipeType = recipeType;
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)autoCookingConfig.inputFilterSlots.get(), s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), "inputFilter");
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)autoCookingConfig.fuelFilterSlots.get(), s -> ForgeHooks.getBurnTime((ItemStack)s, (IRecipeType)recipeType) > 0, "fuelFilter");
        this.fuelFilterLogic.setAllowByDefault();
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent() && this.inputFilterLogic.matchesFilter((ItemStack)s);
        this.isValidFuel = s -> ForgeHooks.getBurnTime((ItemStack)s, (IRecipeType)recipeType) > 0 && this.fuelFilterLogic.matchesFilter((ItemStack)s);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, autoCookingConfig, recipeType, burnTimeModifier);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderInfo();
        }
        super.setEnabled(enabled);
    }

    private void pauseAndRemoveRenderInfo() {
        this.cookingLogic.pause();
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderInfo();
    }

    private void tryPushingOutput() {
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        ItemStack output = this.cookingLogic.getCookOutput();
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (!output.func_190926_b() && inventory.insertItem(output, true).func_190916_E() < output.func_190916_E()) {
            ItemStack ret = inventory.insertItem(output, false);
            this.cookingLogic.getCookingInventory().extractItem(2, output.func_190916_E() - ret.func_190916_E(), false);
        } else {
            this.outputCooldown = 60;
        }
        ItemStack fuel = this.cookingLogic.getFuel();
        if (!fuel.func_190926_b() && ForgeHooks.getBurnTime((ItemStack)fuel, this.recipeType) <= 0 && inventory.insertItem(fuel, true).func_190916_E() < fuel.func_190916_E()) {
            ItemStack ret = inventory.insertItem(fuel, false);
            this.cookingLogic.getCookingInventory().extractItem(1, fuel.func_190916_E() - ret.func_190916_E(), false);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.cookingLogic.tick(world) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(world);
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(CookingUpgradeRenderData.TYPE).map(CookingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(CookingUpgradeRenderData.TYPE, new CookingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
            }
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getCookInput(), this.cookingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getFuel(), this.cookingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(ItemStack stack, Consumer<ItemStack> setSlot, Predicate<ItemStack> isItemValid) {
        ItemStack toExtract;
        IItemHandlerSimpleInserter inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (stack.func_190926_b()) {
            AtomicReference<ItemStack> ret = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
            InventoryHelper.iterate((IItemHandler)inventory, (slot, st) -> {
                if (isItemValid.test((ItemStack)st)) {
                    ret.set(st.func_77946_l());
                }
            }, () -> !((ItemStack)ret.get()).func_190926_b());
            if (ret.get().func_190926_b()) return true;
            toExtract = ret.get();
            toExtract.func_190920_e(toExtract.func_77976_d());
        } else {
            if (stack.func_190916_E() == stack.func_77976_d() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.func_77946_l();
            toExtract.func_190920_e(stack.func_77976_d() - stack.func_190916_E());
        }
        if (InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, true).func_190916_E() <= 0) {
            return true;
        }
        ItemStack toSet = InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, false);
        toSet.func_190917_f(stack.func_190916_E());
        setSlot.accept(toSet);
        return false;
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }

    public static class AutoBlastingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoBlastingUpgradeWrapper, AutoBlastingUpgradeItem, BlastingRecipe> {
        public AutoBlastingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.autoBlastingUpgrade, IRecipeType.field_222151_c, 0.5f);
        }
    }

    public static class AutoSmokingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmokingUpgradeWrapper, AutoSmokingUpgradeItem, SmokingRecipe> {
        public AutoSmokingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.autoSmokingUpgrade, IRecipeType.field_222152_d, 0.5f);
        }
    }

    public static class AutoSmeltingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem, FurnaceRecipe> {
        public AutoSmeltingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(backpackWrapper, upgrade, upgradeSaveHandler, Config.COMMON.autoSmeltingUpgrade, IRecipeType.field_222150_b, 1.0f);
        }
    }
}

