/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankClickMessage;

public class BatteryInventoryPart
extends UpgradeInventoryPartBase<BatteryUpgradeContainer> {
    private static final TextureBlitData TANK_BACKGROUND_TOP = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    private static final TextureBlitData TANK_BACKGROUND_MIDDLE = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    private static final TextureBlitData TANK_BACKGROUND_BOTTOM = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 56), new Dimension(16, 18));
    private static final TextureBlitData CHARGE_SEGMENT = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 74), new Dimension(16, 6));
    private static final TextureBlitData CONNECTION_TOP = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 48), new Dimension(16, 4));
    private static final TextureBlitData CONNECTION_BOTTOM = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 52), new Dimension(16, 4));
    private final Position pos;
    private final int height;
    private final BackpackScreen screen;
    private static final int TOP_BAR_COLOR = 0xFF1A1A;
    private static final int BOTTOM_BAR_COLOR = 0xFFFF40;

    public BatteryInventoryPart(int upgradeSlot, BatteryUpgradeContainer container, Position pos, int height, BackpackScreen screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY(), TANK_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, TANK_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, TANK_BACKGROUND_BOTTOM);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.getY() + yOffset, OVERLAY);
            yOffset += 18;
        }
        this.renderCharge(matrixStack, mouseX, mouseY);
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.getY(), CONNECTION_TOP);
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.getY() + this.height - 4, CONNECTION_BOTTOM);
    }

    private int getTankLeft() {
        return this.pos.getX() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.getY()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.getY() + this.height)) {
            return false;
        }
        ClientPlayerEntity player = this.screen.getMinecraft().field_71439_g;
        ItemStack cursorStack = player.field_71071_by.func_70445_o();
        if (!cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        PacketHandler.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(MatrixStack matrixStack) {
        this.screen.renderOverlay(matrixStack, DyeColor.RED.getColorValue() | 0xAA000000, this.getTankLeft() + 1, this.pos.getY() + 1, 16, this.height - 2);
    }

    private void renderTooltip(int mouseX, int mouseY, int energyStored, int maxEnergyStored) {
        int screenX = this.screen.getGuiLeft() + this.pos.getX() + 10;
        int screenY = this.screen.getGuiTop() + this.pos.getY() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            tooltip.add(new TranslationTextComponent(TranslationHelper.translUpgradeKey("battery.contents_tooltip"), new Object[]{String.format("%,d", energyStored), String.format("%,d", maxEnergyStored)}));
            GuiHelper.setTooltipToRender(tooltip);
        }
    }

    private void renderCharge(MatrixStack matrixStack, int mouseX, int mouseY) {
        int energyStored = ((BatteryUpgradeContainer)this.container).getEnergyStored();
        int maxEneergyStored = ((BatteryUpgradeContainer)this.container).getMaxEnergyStored();
        int segmentHeight = CHARGE_SEGMENT.getHeight();
        int numberOfSegments = this.height / segmentHeight;
        int displayLevel = (int)((float)numberOfSegments * ((float)energyStored / (float)maxEneergyStored));
        int finalRed = 255;
        int finalGreen = 26;
        int finalBlue = 26;
        int initialRed = 255;
        int initialGreen = 255;
        int initialBlue = 64;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < displayLevel; ++i) {
            float percentage = (float)i / (float)(numberOfSegments - 1);
            int red = (int)((float)initialRed * (1.0f - percentage) + (float)finalRed * percentage);
            int green = (int)((float)initialGreen * (1.0f - percentage) + (float)finalGreen * percentage);
            int blue = (int)((float)initialBlue * (1.0f - percentage) + (float)finalBlue * percentage);
            int color = red << 16 | green << 8 | blue | 0xFF000000;
            GuiHelper.coloredBlit(matrix, this.getTankLeft() + 1, this.pos.getY() + this.height - (i + 1) * segmentHeight, CHARGE_SEGMENT, color);
        }
        this.renderTooltip(mouseX, mouseY, energyStored, maxEneergyStored);
    }
}

