/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.SparkleAnimation;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerMethodMapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public abstract class TileEntityMultiblock<T extends MultiblockData>
extends TileEntityMekanism
implements IMultiblock<T>,
IConfigurable {
    private Structure structure = Structure.INVALID;
    private final T defaultMultiblock = this.createMultiblock();
    private boolean prevStructure;
    private boolean isMaster;
    protected MultiblockCache<T> cachedData;
    @Nullable
    protected UUID cachedID = null;
    private long unformedTicks = 100L;

    public TileEntityMultiblock(IBlockProvider blockProvider) {
        super(blockProvider);
        this.cacheCoord();
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public T getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (!this.getMultiblock().isFormed()) {
            ++this.unformedTicks;
            if (!this.playersUsing.isEmpty()) {
                for (PlayerEntity player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                    player.func_71053_j();
                }
            }
        } else {
            this.unformedTicks = 0L;
        }
    }

    @Override
    protected void onUpdateServer() {
        MultiblockData multiblock;
        super.onUpdateServer();
        boolean needsPacket = false;
        if (this.ticker >= 3) {
            this.structure.tick(this, this.ticker % 10 == 0);
        }
        if ((multiblock = this.getMultiblock()).isFormed()) {
            if (!this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = true;
                needsPacket = true;
            }
            if (multiblock.inventoryID != null) {
                this.cachedID = multiblock.inventoryID;
                this.getManager().updateCache(this, multiblock);
                if (this.isMaster()) {
                    if (multiblock.tick(this.field_145850_b)) {
                        needsPacket = true;
                    }
                    if (multiblock.isDirty()) {
                        this.markDirty(false);
                        multiblock.resetDirty();
                    }
                }
            }
        } else {
            this.playersUsing.forEach(PlayerEntity::func_71053_j);
            if (this.cachedID != null) {
                this.getManager().updateCache(this, multiblock);
            }
            if (this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = false;
                needsPacket = true;
            }
            this.isMaster = false;
        }
        if (needsPacket |= this.onUpdateServer(multiblock)) {
            this.sendUpdatePacket();
        }
    }

    protected boolean onUpdateServer(T multiblock) {
        return false;
    }

    @Override
    public void resetForFormed() {
        this.isMaster = false;
        this.prevStructure = false;
    }

    protected void structureChanged(T multiblock) {
        this.invalidateCachedCapabilities();
        if (((MultiblockData)multiblock).isFormed() && !((MultiblockData)multiblock).hasMaster && this.canBeMaster()) {
            ((MultiblockData)multiblock).hasMaster = true;
            this.isMaster = true;
            ((MultiblockData)multiblock).forceUpdateComparatorLevel();
            ((MultiblockData)multiblock).notifyAllUpdateComparator(this.field_145850_b);
        }
        for (Direction side : EnumUtils.DIRECTIONS) {
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (((MultiblockData)multiblock).isFormed() && (((MultiblockData)multiblock).locations.contains(pos) || ((MultiblockData)multiblock).internalLocations.contains(pos))) continue;
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, pos);
            if (this.field_145850_b.func_175623_d(pos) || tile != null && tile.getClass() == this.getClass() || tile instanceof IStructuralMultiblock || tile instanceof IMultiblock) continue;
            WorldUtils.notifyNeighborOfChange(this.field_145850_b, pos, this.func_174877_v());
        }
        if (!((MultiblockData)multiblock).isFormed()) {
            this.markDirtyComparator();
        }
    }

    @Override
    public boolean canBeMaster() {
        return true;
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        if (player.func_225608_bj_() || !this.getMultiblock().isFormed()) {
            return ActionResultType.PASS;
        }
        return this.openGui(player);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.unload();
    }

    @Override
    protected boolean shouldDumpRadiation() {
        return false;
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unload();
    }

    private void unload() {
        if (!this.isRemote()) {
            this.structure.invalidate(this.field_145850_b);
            if (this.cachedID != null) {
                this.getManager().invalidate(this);
            }
        }
    }

    @Override
    public void resetCache() {
        this.cachedID = null;
        this.cachedData = null;
    }

    @Override
    public UUID getCacheID() {
        return this.cachedID;
    }

    @Override
    public MultiblockCache<T> getCache() {
        return this.cachedData;
    }

    @Override
    public void setCache(MultiblockCache<T> cache) {
        this.cachedData = cache;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("rendering", this.isMaster());
        MultiblockData multiblock = this.getMultiblock();
        updateTag.func_74757_a("hasStructure", multiblock.isFormed());
        if (multiblock.isFormed() && this.isMaster()) {
            multiblock.writeUpdateTag(updateTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.isMaster = value;
        });
        MultiblockData multiblock = this.getMultiblock();
        NBTUtils.setBooleanIfPresent(tag, "hasStructure", multiblock::setFormedForce);
        if (this.isMaster()) {
            if (multiblock.isFormed()) {
                multiblock.readUpdateTag(tag);
                this.doMultiblockSparkle(multiblock);
            } else {
                this.isMaster = false;
            }
        }
        this.prevStructure = multiblock.isFormed();
    }

    private void doMultiblockSparkle(T multiblock) {
        ClientPlayerEntity player;
        if (this.isRemote() && ((MultiblockData)multiblock).renderLocation != null && !this.prevStructure && this.unformedTicks >= 5L && this.field_174879_c.func_177951_i((Vector3i)(player = Minecraft.func_71410_x().field_71439_g).func_233580_cy_()) <= 1600.0) {
            if (MekanismConfig.client.enableMultiblockFormationParticles.get()) {
                new SparkleAnimation(this, ((MultiblockData)multiblock).renderLocation, ((MultiblockData)multiblock).length() - 1, ((MultiblockData)multiblock).width() - 1, ((MultiblockData)multiblock).height() - 1).run();
            } else {
                player.func_146105_b((ITextComponent)MekanismLang.MULTIBLOCK_FORMED_CHAT.translateColored(EnumColor.INDIGO, new Object[0]), true);
            }
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        if (!this.getMultiblock().isFormed()) {
            NBTUtils.setUUIDIfPresent(nbtTags, "inventoryID", id -> {
                this.cachedID = id;
                if (nbtTags.func_150297_b("cache", 10)) {
                    this.cachedData = this.getManager().createCache();
                    this.cachedData.load(nbtTags.func_74775_l("cache"));
                }
            });
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.cachedID != null) {
            nbtTags.func_186854_a("inventoryID", this.cachedID);
            if (this.cachedData != null) {
                MultiblockData multiblock = this.getMultiblock();
                if (multiblock.isFormed()) {
                    this.cachedData.sync(multiblock);
                }
                CompoundNBT cacheTags = new CompoundNBT();
                this.cachedData.save(cacheTags);
                nbtTags.func_218657_a("cache", (INBT)cacheTags);
            }
        }
        return nbtTags;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        SyncMapper.INSTANCE.setup(container, this.getMultiblock().getClass(), this::getMultiblock);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        MultiblockData multiblock;
        if (this.isMaster() && (multiblock = this.getMultiblock()).isFormed() && multiblock.getBounds() != null) {
            return new AxisAlignedBB(multiblock.getMinPos(), multiblock.getMaxPos().func_177982_a(1, 1, 1));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return side -> this.getMultiblock().getInventorySlots(side);
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        MultiblockData multiblock;
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote() && (multiblock = this.getMultiblock()).isPositionInsideBounds(this.getStructure(), neighborPos) && (!multiblock.innerNodes.contains(neighborPos) || this.field_145850_b.func_175623_d(neighborPos))) {
            this.getStructure().markForUpdate(this.field_145850_b, true);
        }
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        FormationProtocol.FormationResult result;
        if (!(this.isRemote() || this.getMultiblock().isFormed() || (result = this.getStructure().runUpdate(this)).isFormed() || result.getResultText() == null)) {
            player.func_145747_a(result.getResultText(), Util.field_240973_b_);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    public boolean exposesMultiblockToComputer() {
        return true;
    }

    @Override
    public boolean isComputerCapabilityPersistent() {
        return !this.exposesMultiblockToComputer() && super.isComputerCapabilityPersistent();
    }

    @Override
    public void getComputerMethods(Map<String, BoundComputerMethod> methods) {
        MultiblockData multiblock;
        super.getComputerMethods(methods);
        if (this.exposesMultiblockToComputer() && (multiblock = this.getMultiblock()).isFormed()) {
            ComputerMethodMapper.INSTANCE.getAndBindToHandler(multiblock, methods);
        }
    }

    @ComputerMethod(restriction=ComputerMethodMapper.MethodRestriction.MULTIBLOCK)
    private boolean isFormed() {
        return this.getMultiblock().isFormed();
    }
}

