/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.World;

public abstract class DoubleInputRecipeCache<INPUT_A, INGREDIENT_A extends InputIngredient<INPUT_A>, INPUT_B, INGREDIENT_B extends InputIngredient<INPUT_B>, RECIPE extends MekanismRecipe, CACHE_A extends IInputCache<INPUT_A, INGREDIENT_A, RECIPE>, CACHE_B extends IInputCache<INPUT_B, INGREDIENT_B, RECIPE>>
extends AbstractInputRecipeCache<RECIPE> {
    private final Set<RECIPE> complexIngredientA = new HashSet<RECIPE>();
    private final Set<RECIPE> complexIngredientB = new HashSet<RECIPE>();
    private final Set<RECIPE> complexRecipes = new HashSet<RECIPE>();
    private final Function<RECIPE, INGREDIENT_A> inputAExtractor;
    private final Function<RECIPE, INGREDIENT_B> inputBExtractor;
    private final CACHE_A cacheA;
    private final CACHE_B cacheB;

    protected DoubleInputRecipeCache(MekanismRecipeType<RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT_A> inputAExtractor, CACHE_A cacheA, Function<RECIPE, INGREDIENT_B> inputBExtractor, CACHE_B cacheB) {
        super(recipeType);
        this.inputAExtractor = inputAExtractor;
        this.inputBExtractor = inputBExtractor;
        this.cacheA = cacheA;
        this.cacheB = cacheB;
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheA.clear();
        this.cacheB.clear();
        this.complexIngredientA.clear();
        this.complexIngredientB.clear();
        this.complexRecipes.clear();
    }

    public boolean containsInputA(@Nullable World world, INPUT_A input) {
        return this.containsInput(world, input, this.inputAExtractor, this.cacheA, this.complexIngredientA);
    }

    public boolean containsInputB(@Nullable World world, INPUT_B input) {
        return this.containsInput(world, input, this.inputBExtractor, this.cacheB, this.complexIngredientB);
    }

    public boolean containsInputAB(@Nullable World world, INPUT_A inputA, INPUT_B inputB) {
        return this.containsPairing(world, inputA, this.inputAExtractor, this.cacheA, this.complexIngredientA, inputB, this.inputBExtractor, this.cacheB, this.complexIngredientB);
    }

    public boolean containsInputBA(@Nullable World world, INPUT_A inputA, INPUT_B inputB) {
        return this.containsPairing(world, inputB, this.inputBExtractor, this.cacheB, this.complexIngredientB, inputA, this.inputAExtractor, this.cacheA, this.complexIngredientA);
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable World world, INPUT_A inputA, INPUT_B inputB) {
        return this.findFirstRecipe(world, inputA, inputB, true);
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable World world, INPUT_A inputA, INPUT_B inputB, boolean useCacheA) {
        if (this.cacheA.isEmpty(inputA) || this.cacheB.isEmpty(inputB)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Predicate<MekanismRecipe> matchPredicate = r -> ((BiPredicate)((Object)r)).test(inputA, inputB);
        MekanismRecipe recipe = useCacheA ? this.cacheA.findFirstRecipe(inputA, matchPredicate) : this.cacheB.findFirstRecipe(inputB, matchPredicate);
        return (RECIPE)(recipe == null ? this.findFirstRecipe(this.complexRecipes, matchPredicate) : recipe);
    }

    @Nullable
    public RECIPE findTypeBasedRecipe(@Nullable World world, INPUT_A inputA, INPUT_B inputB, Predicate<RECIPE> matchCriteria) {
        if (this.cacheA.isEmpty(inputA)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Predicate<Object> matchPredicate = this.cacheB.isEmpty(inputB) ? matchCriteria : recipe -> ((InputIngredient)this.inputBExtractor.apply(recipe)).testType(inputB) && matchCriteria.test(recipe);
        RECIPE recipe2 = this.cacheA.findFirstRecipe(inputA, matchPredicate);
        if (recipe2 == null) {
            return (RECIPE)this.findFirstRecipe(this.complexRecipes, r -> ((InputIngredient)this.inputAExtractor.apply(r)).testType(inputA) && matchPredicate.test(r));
        }
        return recipe2;
    }

    @Override
    protected void initCache(List<RECIPE> recipes) {
        for (MekanismRecipe recipe : recipes) {
            boolean complexA = this.cacheA.mapInputs((MekanismRecipe)recipe, (InputIngredient)((InputIngredient)this.inputAExtractor.apply(recipe)));
            boolean complexB = this.cacheB.mapInputs((MekanismRecipe)recipe, (InputIngredient)((InputIngredient)this.inputBExtractor.apply(recipe)));
            if (complexA) {
                this.complexIngredientA.add(recipe);
            }
            if (complexB) {
                this.complexIngredientB.add(recipe);
            }
            if (!complexA && !complexB) continue;
            this.complexRecipes.add(recipe);
        }
    }

    public static abstract class DoubleSameInputRecipeCache<INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe, CACHE extends IInputCache<INPUT, INGREDIENT, RECIPE>>
    extends DoubleInputRecipeCache<INPUT, INGREDIENT, INPUT, INGREDIENT, RECIPE, CACHE, CACHE> {
        protected DoubleSameInputRecipeCache(MekanismRecipeType<RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT> inputAExtractor, Function<RECIPE, INGREDIENT> inputBExtractor, Supplier<CACHE> cacheSupplier) {
            super(recipeType, inputAExtractor, (IInputCache)cacheSupplier.get(), inputBExtractor, (IInputCache)cacheSupplier.get());
        }
    }
}

