/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import mekanism.common.lib.WildcardMatcher;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.items.ItemHandlerHelper;

public interface Finder {
    public static final Finder ANY = stack -> true;

    public static Finder item(Item itemType) {
        return stack -> itemType != Items.field_190931_a && itemType == stack.func_77973_b();
    }

    public static Finder item(ItemStack itemType) {
        return stack -> ItemStack.func_179545_c((ItemStack)itemType, (ItemStack)stack);
    }

    public static Finder strict(ItemStack itemType) {
        return stack -> ItemHandlerHelper.canItemStacksStack((ItemStack)itemType, (ItemStack)stack);
    }

    public static Finder tag(String tagName) {
        return stack -> !stack.func_190926_b() && stack.func_77973_b().getTags().stream().anyMatch(tag -> WildcardMatcher.matches(tagName, tag.toString()));
    }

    public static Finder modID(String modID) {
        return stack -> !stack.func_190926_b() && WildcardMatcher.matches(modID, MekanismUtils.getModId(stack));
    }

    public static Finder material(Material materialType) {
        return stack -> {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
                return false;
            }
            return Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_185904_a() == materialType;
        };
    }

    public boolean modifies(ItemStack var1);
}

