/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.TextComponentUtil;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITierUpgradable;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemTierInstaller
extends Item {
    @Nullable
    private final BaseTier fromTier;
    @Nonnull
    private final BaseTier toTier;

    public ItemTierInstaller(@Nullable BaseTier fromTier, @Nonnull BaseTier toTier, Item.Properties properties) {
        super(properties);
        this.fromTier = fromTier;
        this.toTier = toTier;
    }

    @Nullable
    public BaseTier getFromTier() {
        return this.fromTier;
    }

    @Nonnull
    public BaseTier getToTier() {
        return this.toTier;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return TextComponentUtil.build(this.toTier.getTextColor(), super.func_200295_i(stack));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (world.field_72995_K || player == null) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeUpgradeable.class)) {
            AttributeUpgradeable upgradeableBlock = Attribute.get(block, AttributeUpgradeable.class);
            BaseTier baseTier = Attribute.getBaseTier(block);
            if (baseTier == this.fromTier && baseTier != this.toTier) {
                BlockState upgradeState = upgradeableBlock.upgradeResult(state, this.toTier);
                if (state == upgradeState) {
                    return ActionResultType.PASS;
                }
                TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
                if (tile instanceof ITierUpgradable) {
                    if (tile instanceof TileEntityMekanism && !((TileEntityMekanism)tile).playersUsing.isEmpty()) {
                        return ActionResultType.FAIL;
                    }
                    IUpgradeData upgradeData = ((ITierUpgradable)tile).getUpgradeData();
                    if (upgradeData == null) {
                        if (((ITierUpgradable)tile).canBeUpgraded()) {
                            Mekanism.logger.warn("Got no upgrade data for block {} at position: {} in {} but it said it would be able to provide some.", (Object)block, (Object)pos, (Object)world);
                            return ActionResultType.FAIL;
                        }
                    } else {
                        world.func_175656_a(pos, upgradeState);
                        TileEntityMekanism upgradedTile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos);
                        if (upgradedTile == null) {
                            Mekanism.logger.warn("Error upgrading block at position: {} in {}.", (Object)pos, (Object)world);
                            return ActionResultType.FAIL;
                        }
                        if (tile instanceof ITileDirectional && ((ITileDirectional)tile).isDirectional()) {
                            upgradedTile.setFacing(((ITileDirectional)tile).getDirection());
                        }
                        upgradedTile.parseUpgradeData(upgradeData);
                        upgradedTile.sendUpdatePacket();
                        upgradedTile.func_70296_d();
                        if (!player.func_184812_l_()) {
                            context.func_195996_i().func_190918_g(1);
                        }
                        return ActionResultType.SUCCESS;
                    }
                }
            }
        }
        return ActionResultType.PASS;
    }
}

