/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import mekanism.common.integration.crafttweaker.tag.CrTGasTagManager;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=GasStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.GasStackIngredient")
public class CrTGasStackIngredient {
    private CrTGasStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(Gas instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "GasStackIngredients", "gas");
        return GasStackIngredient.from(instance, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(ICrTChemicalStack.ICrTGasStack instance) {
        CrTIngredientHelper.assertValid(instance, "GasStackIngredients");
        return GasStackIngredient.from((GasStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(MCTag<Gas> gasTag, long amount) {
        ITag tag = CrTIngredientHelper.assertValidAndGet(gasTag, amount, CrTGasTagManager.INSTANCE::getInternal, "GasStackIngredients");
        return GasStackIngredient.from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(MCTagWithAmount<Gas> gasTag) {
        return CrTGasStackIngredient.from((MCTag<Gas>)gasTag.getTag(), (long)gasTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient createMulti(GasStackIngredient ... ingredients) {
        return (GasStackIngredient)CrTIngredientHelper.createMulti((String)"GasStackIngredients", GasStackIngredient::createMulti, (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(GasStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static GasStackIngredient or(GasStackIngredient _this, GasStackIngredient other) {
        return GasStackIngredient.createMulti(_this, other);
    }
}

