/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ElectrolyticSeparatorEnergyContainer
extends MachineEnergyContainer<TileEntityElectrolyticSeparator> {
    public static ElectrolyticSeparatorEnergyContainer input(TileEntityElectrolyticSeparator tile) {
        AttributeEnergy electricBlock = ElectrolyticSeparatorEnergyContainer.validateBlock(tile);
        return new ElectrolyticSeparatorEnergyContainer(electricBlock.getStorage(), electricBlock.getUsage(), (Predicate<AutomationType>)notExternal, (Predicate<AutomationType>)alwaysTrue, tile);
    }

    private ElectrolyticSeparatorEnergyContainer(FloatingLong maxEnergy, FloatingLong energyPerTick, Predicate<@NonNull AutomationType> canExtract, Predicate<@NonNull AutomationType> canInsert, TileEntityElectrolyticSeparator tile) {
        super(maxEnergy, energyPerTick, canExtract, canInsert, tile);
    }

    @Override
    public FloatingLong getBaseEnergyPerTick() {
        return super.getBaseEnergyPerTick().multiply(((TileEntityElectrolyticSeparator)this.tile).getRecipeEnergyMultiplier());
    }

    @Override
    public void updateEnergyPerTick() {
        this.currentEnergyPerTick = this.getBaseEnergyPerTick();
    }
}

