/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.prefab;

import java.util.Random;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTile<TILE extends TileEntityMekanism, TYPE extends BlockTypeTile<TILE>>
extends BlockBase<TYPE>
implements IHasTileEntity<TILE> {
    public BlockTile(TYPE type) {
        this(type, UnaryOperator.identity());
    }

    public BlockTile(TYPE type, UnaryOperator<AbstractBlock.Properties> propertiesModifier) {
        this(type, (AbstractBlock.Properties)propertiesModifier.apply(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.5f, 16.0f).func_235861_h_()));
    }

    public BlockTile(TYPE type, AbstractBlock.Properties properties) {
        super(type, properties);
    }

    @Override
    public TileEntityType<TILE> getTileType() {
        return ((BlockTypeTile)this.type).getTileType();
    }

    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return this.genericClientActivated(player, hand);
        }
        if (tile.tryWrench(state, player, hand, hit) != WrenchResult.PASS) {
            return ActionResultType.SUCCESS;
        }
        return ((BlockTypeTile)this.type).has(AttributeGui.class) ? tile.openGui(player) : ActionResultType.PASS;
    }

    @Override
    protected float getDestroyProgress(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable TileEntity tile) {
        return SecurityUtils.canAccess(player, tile) ? super.getDestroyProgress(state, player, world, pos, tile) : 0.0f;
    }

    @Override
    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
        super.func_180655_c(state, world, pos, random);
        if (MekanismConfig.client.machineEffects.get() && ((BlockTypeTile)this.type).has(AttributeParticleFX.class) && Attribute.isActive(state)) {
            Direction facing = Attribute.getFacing(state);
            for (Function<Random, AttributeParticleFX.Particle> particleFunction : ((BlockTypeTile)this.type).get(AttributeParticleFX.class).getParticleFunctions()) {
                AttributeParticleFX.Particle particle = particleFunction.apply(random);
                Pos3D particlePos = particle.getPos();
                if (facing == Direction.WEST) {
                    particlePos = particlePos.func_178785_b(90.0f);
                } else if (facing == Direction.EAST) {
                    particlePos = particlePos.func_178785_b(270.0f);
                } else if (facing == Direction.NORTH) {
                    particlePos = particlePos.func_178785_b(180.0f);
                }
                particlePos = particlePos.func_72441_c((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_195594_a(particle.getType(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    @Deprecated
    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        TileEntityMekanism tile;
        if (!world.field_72995_K && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)world, pos)) != null) {
            tile.onNeighborChange(neighborBlock, neighborPos);
        }
    }

    @Deprecated
    public boolean func_149744_f(@Nonnull BlockState state) {
        return ((BlockTypeTile)this.type).has(Attributes.AttributeRedstoneEmitter.class);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return ((BlockTypeTile)this.type).has(Attributes.AttributeRedstoneEmitter.class) || super.canConnectRedstone(state, world, pos, side);
    }

    @Deprecated
    public int func_180656_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        if (((BlockTypeTile)this.type).has(Attributes.AttributeRedstoneEmitter.class)) {
            TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, world, pos);
            return ((BlockTypeTile)this.type).get(Attributes.AttributeRedstoneEmitter.class).getRedstoneLevel(tile);
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public static class BlockTileModel<TILE extends TileEntityMekanism, BLOCK extends BlockTypeTile<TILE>>
    extends BlockTile<TILE, BLOCK>
    implements IStateFluidLoggable {
        public BlockTileModel(BLOCK type) {
            super(type);
        }

        public BlockTileModel(BLOCK type, AbstractBlock.Properties properties) {
            super(type, properties);
        }
    }
}

