/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.RenderData;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3d;

@ParametersAreNonnullByDefault
public abstract class MekanismTileEntityRenderer<TILE extends TileEntity>
extends TileEntityRenderer<TILE> {
    protected MekanismTileEntityRenderer(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    public void func_225616_a_(TILE tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight) {
        if (tile.func_145831_w() != null) {
            IProfiler profiler = tile.func_145831_w().func_217381_Z();
            profiler.func_76320_a(this.getProfilerSection());
            this.render(tile, partialTick, matrix, renderer, light, overlayLight, profiler);
            profiler.func_76319_b();
        }
    }

    protected abstract void render(TILE var1, float var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, int var6, IProfiler var7);

    protected abstract String getProfilerSection();

    protected boolean isInsideBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vector3d projectedView = this.field_228858_b_.field_217666_g.func_216785_c();
        return minX <= projectedView.field_72450_a && projectedView.field_72450_a <= maxX && minY <= projectedView.field_72448_b && projectedView.field_72448_b <= maxY && minZ <= projectedView.field_72449_c && projectedView.field_72449_c <= maxZ;
    }

    protected RenderResizableCuboid.FaceDisplay getFaceDisplay(RenderData data, MekanismRenderer.Model3D model) {
        return this.isInsideBounds(data.location.func_177958_n(), data.location.func_177956_o(), data.location.func_177952_p(), data.location.func_177958_n() + data.length, (float)data.location.func_177956_o() + ModelRenderer.getActualHeight(model), data.location.func_177952_p() + data.width) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.FRONT;
    }

    protected BooleanSupplier isInsideMultiblock(RenderData data) {
        return () -> this.isInsideBounds(data.location.func_177958_n(), data.location.func_177956_o(), data.location.func_177952_p(), data.location.func_177958_n() + data.length, data.location.func_177956_o() + data.height, data.location.func_177952_p() + data.width);
    }
}

