/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.baked;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadTransformation;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;

public class MekanismModel
implements IMultipartModelGeometry<MekanismModel> {
    private final Multimap<String, BlockPartWrapper> elements;

    public MekanismModel(Multimap<String, BlockPartWrapper> list) {
        this.elements = list;
    }

    public Collection<BlockPartWrapper> getParts() {
        return this.elements.values();
    }

    public Optional<BlockPartWrapper> getPart(String name) {
        return this.elements.get((Object)name).stream().findFirst();
    }

    public static class BlockPartWrapper
    implements IModelGeometryPart {
        private final String name;
        private final BlockPart blockPart;
        private final Object2IntMap<BlockPartFace> litFaceMap = new Object2IntOpenHashMap();

        public BlockPartWrapper(String name, BlockPart blockPart) {
            this.name = name;
            this.blockPart = blockPart;
        }

        public BlockPart getPart() {
            return this.blockPart;
        }

        public String name() {
            return this.name;
        }

        public void light(Direction side, int light) {
            this.litFaceMap.put(this.blockPart.field_178240_c.get(side), light);
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
            for (Direction direction : this.blockPart.field_178240_c.keySet()) {
                BlockPartFace face = (BlockPartFace)this.blockPart.field_178240_c.get(direction);
                TextureAtlasSprite sprite = spriteGetter.apply(owner.resolveTexture(face.field_178242_d));
                BakedQuad quad = BlockModel.makeBakedQuad((BlockPart)this.blockPart, (BlockPartFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)modelTransform, (ResourceLocation)modelLocation);
                if (this.litFaceMap.containsKey((Object)face)) {
                    quad = new Quad(quad).transform(QuadTransformation.light((float)this.litFaceMap.getInt((Object)face) / 15.0f)).bake();
                }
                if (face.field_178244_b == null) {
                    modelBuilder.addGeneralQuad(quad);
                    continue;
                }
                modelBuilder.addFaceQuad(modelTransform.func_225615_b_().rotateTransform(face.field_178244_b), quad);
            }
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockPartFace face : this.blockPart.field_178240_c.values()) {
                RenderMaterial texture = owner.resolveTexture(face.field_178242_d);
                if (Objects.equals(texture.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
            return textures;
        }
    }

    public static class Loader
    implements IModelLoader<MekanismModel> {
        public static final Loader INSTANCE = new Loader();

        protected Loader() {
        }

        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        }

        @Nonnull
        public MekanismModel read(@Nonnull JsonDeserializationContext ctx, @Nonnull JsonObject modelContents) {
            return new MekanismModel(Loader.readElements(ctx, modelContents));
        }

        protected static Multimap<String, BlockPartWrapper> readElements(@Nonnull JsonDeserializationContext ctx, @Nonnull JsonObject modelContents) {
            HashMultimap multimap = HashMultimap.create();
            if (modelContents.has("elements")) {
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)modelContents, (String)"elements")) {
                    JsonObject obj = element.getAsJsonObject();
                    BlockPart part = (BlockPart)ctx.deserialize(element, BlockPart.class);
                    String name = obj.has("name") ? obj.get("name").getAsString() : "undefined";
                    BlockPartWrapper wrapper = new BlockPartWrapper(name, part);
                    multimap.put((Object)name, (Object)wrapper);
                    if (!obj.has("faces")) continue;
                    JsonObject faces = obj.getAsJsonObject("faces");
                    faces.entrySet().forEach(e -> {
                        Direction side = Direction.func_176739_a((String)((String)e.getKey()));
                        if (side == null) {
                            return;
                        }
                        JsonObject face = ((JsonElement)e.getValue()).getAsJsonObject();
                        if (face.has("lightLevel")) {
                            int light = face.get("lightLevel").getAsInt();
                            wrapper.light(side, light);
                        }
                    });
                }
            }
            return multimap;
        }
    }
}

