/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.model.AbstractTropicalFishModel;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.BoarModel;
import net.minecraft.client.renderer.entity.model.CodModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EndermiteModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.LlamaModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.PandaModel;
import net.minecraft.client.renderer.entity.model.ParrotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PufferFishBigModel;
import net.minecraft.client.renderer.entity.model.PufferFishMediumModel;
import net.minecraft.client.renderer.entity.model.PufferFishSmallModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.SalmonModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.variant.HorseVariant;
import xaero.common.minimap.render.radar.variant.IronGolemVariant;
import xaero.common.minimap.render.radar.variant.LlamaVariant;
import xaero.common.minimap.render.radar.variant.SaddleVariant;
import xaero.common.minimap.render.radar.variant.TamableVariant;
import xaero.common.minimap.render.radar.variant.TropicalFishVariant;
import xaero.common.minimap.render.radar.variant.VillagerVariant;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconDefinitions {
    static float slimeSquishBU;
    public static final Method BUILD_VARIANT_ID_STRING_METHOD;
    public static final Method GET_VARIANT_ID_STRING_METHOD;
    private static StringBuilder VARIANT_STRING_BUILDER;

    public static List<String> getMainModelPartFields(EntityRenderer<?> renderer, EntityModel<?> model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof BatModel) {
            String modelClassPath = BatModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_82895_a"));
        } else if (model instanceof BlazeModel) {
            String modelClassPath = BlazeModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78105_b"));
        } else if (model instanceof SpiderModel) {
            String modelClassPath = SpiderModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78209_a"));
        } else if (model instanceof CodModel) {
            String modelClassPath = CodModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "nose"));
            result.add(String.format("%s;%s", modelClassPath, "field_203726_d"));
        } else if (model instanceof CreeperModel) {
            String modelClassPath = CreeperModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78135_a"));
        } else if (model instanceof LlamaModel) {
            String modelClassPath = LlamaModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_228273_a_"));
        } else if (model instanceof ParrotModel) {
            String modelClassPath = ParrotModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_192768_e"));
        } else if (model instanceof PhantomModel) {
            String modelClassPath = PhantomModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "body"));
            result.add(String.format("%s;%s", modelClassPath, "field_203070_a"));
        } else if (model instanceof RabbitModel) {
            String modelClassPath = RabbitModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_178704_h"));
        } else if (model instanceof RavagerModel) {
            String modelClassPath = RavagerModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_217168_a"));
        } else if (model instanceof SquidModel) {
            String modelClassPath = SquidModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "body"));
            result.add(String.format("%s;%s", modelClassPath, "field_78202_a"));
        } else if (model instanceof StriderModel) {
            String modelClassPath = StriderModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "body"));
            result.add(String.format("%s;%s", modelClassPath, "field_239120_f_"));
        } else if (model instanceof IronGolemModel) {
            String modelClassPath = IronGolemModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78178_a"));
        } else if (model instanceof SnowManModel) {
            String modelClassPath = SnowManModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78195_c"));
        } else if (model instanceof EnderDragonRenderer.EnderDragonModel) {
            String modelClassPath = EnderDragonRenderer.EnderDragonModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_78221_a"));
        } else if (model instanceof GhastModel) {
            String modelClassPath = GhastModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "parts[0]"));
            result.add(String.format("%s;%s", modelClassPath, "field_228260_b_[0]"));
        } else if (model instanceof ShulkerModel) {
            String modelClassPath = ShulkerModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "field_187066_a"));
        }
        return result;
    }

    public static List<String> getSecondaryModelPartsFields(EntityRenderer<?> renderer, EntityModel<?> model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof RabbitModel) {
            String modelClassPath = RabbitModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "earRight"));
            result.add(String.format("%s;%s", modelClassPath, "field_178705_i"));
            result.add(String.format("%s;%s", modelClassPath, "earLeft"));
            result.add(String.format("%s;%s", modelClassPath, "field_178702_j"));
            result.add(String.format("%s;%s", modelClassPath, "nose"));
            result.add(String.format("%s;%s", modelClassPath, "field_178700_l"));
        }
        return result;
    }

    public static boolean forceFieldCheck(EntityModel<?> entityModel) {
        return false;
    }

    static void customTransformation(MatrixStack matrixStack, EntityModel em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof CodModel || em instanceof SalmonModel) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof AbstractTropicalFishModel) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        } else if (em instanceof BatModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof HorseModel) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(65.0f));
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof DolphinModel) {
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof GuardianModel || em instanceof SquidModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof BoarModel) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof LlamaModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slimeSquishBU = slime.field_70811_b;
            slime.field_70811_b = 0.0f;
        } else if (em instanceof GhastModel || em instanceof RavagerModel || em instanceof StriderModel || em instanceof EnderDragonRenderer.EnderDragonModel) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof WitherModel) {
            matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
        } else if (em instanceof PhantomModel) {
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        } else if (em instanceof PandaModel) {
            matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        }
    }

    public static void customPostRenderTransformation(MatrixStack matrixStack, EntityModel entityModel, Entity entity) {
        if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slime.field_70811_b = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(EntityModel em) {
        return em instanceof CodModel || em instanceof SalmonModel || em instanceof AbstractTropicalFishModel || em instanceof BeeModel || em instanceof DolphinModel || em instanceof GuardianModel || em instanceof EndermiteModel || em instanceof MagmaCubeModel || em instanceof SlimeModel || em instanceof PufferFishBigModel || em instanceof PufferFishMediumModel || em instanceof PufferFishSmallModel || em instanceof SilverfishModel || em instanceof WitherModel;
    }

    public static EntityIconCustomRenderer getCustomLayer(EntityRenderer entityRenderer, Entity entity) {
        return null;
    }

    public static Object getModelRoot(EntityRenderer<?> entityRenderer, EntityModel<?> entityModel) {
        return entityModel;
    }

    public static <E extends Entity> Object getVariant(ResourceLocation entityTexture, EntityRenderer<? super E> entityRenderer, E entity) {
        if (entityRenderer instanceof HorseRenderer) {
            return new HorseVariant(entityTexture, ((HorseEntity)entity).func_234240_eM_());
        }
        if (entityRenderer instanceof VillagerRenderer || entityRenderer instanceof ZombieVillagerRenderer) {
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            VillagerType villagertype = villagerdata.func_221129_a();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            int villagerprofessionlevel = villagerdata.func_221132_c();
            return new VillagerVariant(entityTexture, ((LivingEntity)entity).func_70631_g_(), villagertype, villagerprofession, villagerprofessionlevel);
        }
        if (entityRenderer instanceof CatRenderer || entityRenderer instanceof WolfRenderer) {
            return new TamableVariant(entityTexture, ((TameableEntity)entity).func_70909_n());
        }
        if (entityRenderer instanceof IronGolemRenderer) {
            return new IronGolemVariant(entityTexture, ((IronGolemEntity)entity).func_226512_l_());
        }
        if (entityRenderer instanceof LlamaRenderer) {
            LlamaEntity llama = (LlamaEntity)entity;
            return new LlamaVariant(entityTexture, llama.func_213800_eB(), llama.func_190704_dO());
        }
        if (entityRenderer instanceof PigRenderer) {
            return new SaddleVariant(entityTexture, ((PigEntity)entity).func_110257_ck());
        }
        if (entityRenderer instanceof StriderRenderer) {
            return new SaddleVariant(entityTexture, ((StriderEntity)entity).func_110257_ck());
        }
        if (entityRenderer instanceof TropicalFishRenderer) {
            TropicalFishEntity fish = (TropicalFishEntity)entity;
            return new TropicalFishVariant(entityTexture, fish.func_204221_dB());
        }
        return entityTexture;
    }

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer entityRenderer, Entity entity) {
        ResourceLocation entityTexture = null;
        try {
            ResourceLocation entityTextureUnchecked;
            entityTexture = entityTextureUnchecked = entityRenderer.func_110775_a(entity);
        }
        catch (Throwable e) {
            MinimapLogs.LOGGER.error("Exception while fetching entity texture to build its variant ID for " + EntityType.func_200718_a((EntityType)entity.func_200600_R()));
            MinimapLogs.LOGGER.error("The exception is most likely on another mod's end and suppressing it here could lead to more issues. Please report to appropriate mod devs.", e);
        }
        if (entityTexture == null) {
            return;
        }
        stringBuilder.append(EntityIconDefinitions.getVariant(entityTexture, entityRenderer, entity));
    }

    public static String getVariantString(EntityRenderer entityRenderer, Entity entity) {
        StringBuilder stringBuilder = VARIANT_STRING_BUILDER;
        stringBuilder.setLength(0);
        EntityIconDefinitions.buildVariantIdString(stringBuilder, entityRenderer, entity);
        return stringBuilder.toString();
    }

    static {
        try {
            BUILD_VARIANT_ID_STRING_METHOD = EntityIconDefinitions.class.getDeclaredMethod("buildVariantIdString", StringBuilder.class, EntityRenderer.class, Entity.class);
            GET_VARIANT_ID_STRING_METHOD = EntityIconDefinitions.class.getDeclaredMethod("getVariantString", EntityRenderer.class, Entity.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        VARIANT_STRING_BUILDER = new StringBuilder();
    }
}

