/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContextForge;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandler;
import xaero.common.message.PacketConsumerForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandlerForge
extends MinimapMessageHandler {
    private final IXaeroMinimap modMain;
    private final PlatformContextForge xaeroHudForge;

    public MinimapMessageHandlerForge(IXaeroMinimap modMain, PlatformContextForge xaeroHudForge) {
        this.modMain = modMain;
        this.xaeroHudForge = xaeroHudForge;
    }

    @Override
    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<PacketBuffer, T> decoder, BiConsumer<T, PacketBuffer> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            this.xaeroHudForge.getNetwork().registerMessage(index, type, encoder, decoder, consumer, Optional.of(clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT));
            return;
        }
        this.xaeroHudForge.getNetwork().registerMessage(index, type, encoder, decoder, consumer);
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToPlayer(ServerPlayerEntity player, T message) {
        this.xaeroHudForge.getNetwork().send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToServer(T message) {
        this.xaeroHudForge.getNetwork().sendToServer(message);
    }
}

