/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class CompTierRegistry {
    private List<Record> records = new ArrayList<Record>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        if (((Boolean)CommonConfig.GENERAL.enableExtraCompactingRules.get()).booleanValue()) {
            this.register(new ItemStack((IItemProvider)Blocks.field_150435_aG), new ItemStack((IItemProvider)Items.field_151119_aD), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_196604_cC), new ItemStack((IItemProvider)Items.field_151126_ay), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_150426_aN), new ItemStack((IItemProvider)Items.field_151114_aO), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_196584_bK), new ItemStack((IItemProvider)Items.field_151118_aC), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_196653_dH), new ItemStack((IItemProvider)Items.field_196154_dH), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_189878_dg), new ItemStack((IItemProvider)Items.field_151075_bm), 9);
            this.register(new ItemStack((IItemProvider)Blocks.field_150371_ca), new ItemStack((IItemProvider)Items.field_151128_bU), 4);
            this.register(new ItemStack((IItemProvider)Blocks.field_150440_ba), new ItemStack((IItemProvider)Items.field_151127_ba), 9);
            if (!ModList.get().isLoaded("extrautilities")) {
                this.register(new ItemStack((IItemProvider)Blocks.field_150322_A), new ItemStack((IItemProvider)Blocks.field_150354_m), 4);
                this.register(new ItemStack((IItemProvider)Blocks.field_180395_cM), new ItemStack((IItemProvider)Blocks.field_196611_F, 1), 4);
            }
        }
        CommonConfig.onLoad(() -> ((List)CommonConfig.GENERAL.compRules.get()).forEach(this::register));
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    public boolean register(@Nonnull ItemStack upper, @Nonnull ItemStack lower, int convRate) {
        if (upper.func_190926_b() || lower.func_190926_b()) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record(upper.func_77946_l(), lower.func_77946_l(), convRate);
        r.upper.func_190920_e(1);
        r.lower.func_190920_e(1);
        this.records.add(r);
        StorageDrawers.log.info("New compacting rule " + convRate + " " + lower.func_77973_b().toString() + " = 1 " + upper.func_77973_b().toString());
        return true;
    }

    public static boolean validateRuleSyntax(String rule) {
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = ResourceLocation.func_208304_a((String)parts[0]);
        ResourceLocation lowerResource = ResourceLocation.func_208304_a((String)parts[1]);
        if (upperResource == null || lowerResource == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return conv >= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void register(List<String> rules) {
        rules.forEach(this::register);
    }

    public boolean register(String rule) {
        if (!this.initialized) {
            this.pendingRules.add(rule);
            return true;
        }
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = new ResourceLocation(parts[0]);
        Item upperItem = (Item)ForgeRegistries.ITEMS.getValue(upperResource);
        ResourceLocation lowerResource = new ResourceLocation(parts[1]);
        Item lowerItem = (Item)ForgeRegistries.ITEMS.getValue(lowerResource);
        if (upperItem == null || lowerItem == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return this.register(new ItemStack((IItemProvider)upperItem), new ItemStack((IItemProvider)lowerItem), conv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean unregisterUpperTarget(@Nonnull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(@Nonnull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Record r : this.records) {
            if (!stack.func_77969_a(r.lower) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Record r : this.records) {
            if (!stack.func_77969_a(r.upper) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)r.upper)) continue;
            return r;
        }
        return null;
    }

    public class Record {
        @Nonnull
        public final ItemStack upper;
        @Nonnull
        public final ItemStack lower;
        public final int convRate;

        public Record(@Nonnull ItemStack upper, ItemStack lower, int convRate) {
            this.upper = upper;
            this.lower = lower;
            this.convRate = convRate;
        }
    }
}

