/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.mixin.resources;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.interfaces.IPackResources;
import com.ccr4ft3r.lightspeed.util.CacheUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.VirtualAssetsPack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VirtualAssetsPack.class})
public abstract class DefaultClientPackResourcesMixin
implements IPackResources {
    private Map<String, Boolean> existenceByClientResource = Maps.newConcurrentMap();
    private Map<String, Boolean> existenceByServerResource = Maps.newConcurrentMap();
    private String id;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturnInjected(ResourceIndex p_i48115_1_, CallbackInfo ci) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        GlobalCache.add(this);
        this.id = Minecraft.func_71410_x().func_175600_c();
        this.existenceByClientResource = GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.id + "-client", i -> Maps.newConcurrentMap());
        this.existenceByServerResource = GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.id + "-server", i -> Maps.newConcurrentMap());
    }

    @Inject(method={"hasResource"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasResourceHeadInjected(ResourcePackType p_10355_, ResourceLocation p_10356_, CallbackInfoReturnable<Boolean> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        Boolean exists = this.exists(p_10355_, p_10356_.toString());
        if (exists != null) {
            cir.setReturnValue((Object)exists);
        }
    }

    @Inject(method={"hasResource"}, at={@At(value="RETURN")})
    public void hasResourceReturnInjected(ResourcePackType p_10355_, ResourceLocation p_10356_, CallbackInfoReturnable<Boolean> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        this.cacheExists(p_10355_, p_10356_.toString(), (Boolean)cir.getReturnValue());
    }

    public Boolean exists(ResourcePackType packType, String resourceName) {
        if (packType == ResourcePackType.CLIENT_RESOURCES) {
            return this.existenceByClientResource.get(resourceName);
        }
        return this.existenceByServerResource.get(resourceName);
    }

    public void cacheExists(ResourcePackType packType, String resourceName, boolean exists) {
        if (packType == ResourcePackType.CLIENT_RESOURCES) {
            this.existenceByClientResource.put(resourceName, exists);
        } else {
            this.existenceByServerResource.put(resourceName, exists);
        }
    }

    @Override
    public void persistAndClearCache() {
        CacheUtil.persist(this.existenceByClientResource, new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.id + "-client.ser"));
        CacheUtil.persist(this.existenceByServerResource, new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.id + "-server.ser"));
        this.existenceByClientResource.clear();
        this.existenceByServerResource.clear();
    }
}

