/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class KeyBindingList
extends AbstractOptionList<Entry> {
    private static final List<KeyBinding> DEFAULT_BINDINGS = (List)Util.func_199748_a(() -> {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        ArrayList<KeyBinding> bindings = new ArrayList<KeyBinding>();
        bindings.add(settings.field_74312_F);
        bindings.add(settings.field_74313_G);
        bindings.add(settings.field_74351_w);
        bindings.add(settings.field_74370_x);
        bindings.add(settings.field_74368_y);
        bindings.add(settings.field_74366_z);
        bindings.add(settings.field_74314_A);
        bindings.add(settings.field_228046_af_);
        bindings.add(settings.field_151444_V);
        bindings.add(settings.field_74316_C);
        bindings.add(settings.field_151445_Q);
        bindings.add(settings.field_74310_D);
        bindings.add(settings.field_74321_H);
        bindings.add(settings.field_74322_I);
        bindings.add(settings.field_74323_J);
        bindings.add(settings.field_151447_Z);
        bindings.add(settings.field_151457_aa);
        bindings.add(settings.field_151458_ab);
        bindings.add(settings.field_152395_am);
        bindings.add(settings.field_178883_an);
        bindings.add(settings.field_186718_X);
        bindings.add(settings.field_193629_ap);
        bindings.add(settings.field_193630_aq);
        bindings.add(settings.field_194146_ao);
        bindings.addAll(Arrays.asList(settings.field_151456_ac));
        return ImmutableList.copyOf(bindings);
    });
    private SelectKeyBindingScreen parent;
    private Map<String, List<KeyBinding>> categories = new LinkedHashMap<String, List<KeyBinding>>();

    public KeyBindingList(SelectKeyBindingScreen parent, Minecraft mc, int widthIn, int heightIn, int topIn, int bottomIn, int itemHeightIn) {
        super(mc, widthIn, heightIn, topIn, bottomIn, itemHeightIn);
        this.parent = parent;
        this.updateList(false);
    }

    public void updateList(boolean showUnbound) {
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        Stream.of(this.field_230668_b_.field_71474_y.field_74324_K).filter(binding -> !DEFAULT_BINDINGS.contains(binding)).forEach(binding -> this.categories.computeIfAbsent(binding.func_151466_e(), category -> new ArrayList()).add(binding));
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.func_230513_b_((AbstractList.AbstractListEntry)new CategoryEntry((ITextComponent)new TranslationTextComponent(category).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})));
                list.forEach(binding -> this.func_230513_b_((AbstractList.AbstractListEntry)new KeyBindingEntry((KeyBinding)binding)));
            }
        });
    }

    public class KeyBindingEntry
    extends Entry {
        private KeyBinding binding;
        private TextComponent label;
        private Button addBinding;
        private Button removeBinding;

        protected KeyBindingEntry(KeyBinding binding) {
            this.binding = binding;
            this.label = new TranslationTextComponent(binding.func_151464_g());
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                BindingRegistry.getInstance().addKeyAdapter(new KeyAdapterBinding(-1, this.binding));
                this.addBinding.field_230693_o_ = false;
                this.removeBinding.field_230693_o_ = true;
                KeyBindingList.this.parent.updateButtons();
            });
            this.removeBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 15, 10, 10, button -> {
                KeyAdapterBinding keyAdapter = BindingRegistry.getInstance().getKeyAdapterByDescriptionKey(this.binding.func_151464_g() + ".custom");
                if (keyAdapter != null) {
                    BindingRegistry.getInstance().removeKeyAdapter(keyAdapter);
                    RadialMenuHandler.instance().removeBinding(keyAdapter);
                }
                this.addBinding.field_230693_o_ = true;
                this.removeBinding.field_230693_o_ = false;
                KeyBindingList.this.parent.updateButtons();
            });
            this.addBinding.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getKeyBinding() == this.binding);
            this.removeBinding.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getKeyBinding() == this.binding);
        }

        public void updateButtons() {
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getKeyBinding() == this.binding);
            this.removeBinding.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getKeyBinding() == this.binding);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.addBinding, (Object)this.removeBinding);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((KeyBindingList)KeyBindingList.this).field_230668_b_.field_71466_p.func_243246_a(matrixStack, (ITextComponent)this.label, (float)(left - 15), (float)(y + 6), 0xFFFFFF);
            this.addBinding.field_230690_l_ = left + width - 37;
            this.addBinding.field_230691_m_ = y;
            this.addBinding.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.removeBinding.field_230690_l_ = left + width - 15;
            this.removeBinding.field_230691_m_ = y;
            this.removeBinding.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    protected class CategoryEntry
    extends Entry {
        private final ITextComponent label;
        private final int labelWidth;

        protected CategoryEntry(ITextComponent label) {
            this.label = label;
            this.labelWidth = ((KeyBindingList)KeyBindingList.this).field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)this.label);
        }

        public boolean func_231049_c__(boolean focus) {
            return false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int p_230432_4_, int p_230432_5_, int itemHeight, int p_230432_7_, int p_230432_8_, boolean selected, float partialTicks) {
            int labelX = (int)((float)((KeyBindingList)KeyBindingList.this).field_230668_b_.field_71462_r.field_230708_k_ / 2.0f - (float)this.labelWidth / 2.0f);
            int labelY = y + itemHeight - 9 - 2;
            ((KeyBindingList)KeyBindingList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, this.label, (float)labelX, (float)labelY, -1);
        }
    }

    abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        Entry() {
        }
    }
}

