/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ListMenuScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ButtonBindingListMenuScreen
extends ListMenuScreen {
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    protected ButtonBindingListMenuScreen(Screen parent, ITextComponent title, int itemHeight) {
        super(parent, title, itemHeight);
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.categories.put("key.categories.controllable_custom", new ArrayList());
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void updateList(List<ListMenuScreen.Item> entries, boolean showUnbound) {
        this.categories.forEach((category, list) -> list.clear());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && binding.getButton() != -1) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                entries.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (ITextComponent)new TranslationTextComponent(category).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})));
                list.forEach(binding -> entries.add(this.createItemFromBinding((ButtonBinding)binding)));
            }
        });
    }

    protected abstract ListMenuScreen.Item createItemFromBinding(ButtonBinding var1);
}

