/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutCopy;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import appeng.worldgen.meteorite.fallout.FalloutSand;
import appeng.worldgen.meteorite.fallout.FalloutSnow;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public final class MeteoritePlacer {
    private static final double PRESSES_SPAWN_CHANCE = 0.7;
    private static final int SKYSTONE_SPAWN_LIMIT = 12;
    private final IBlockDefinition skyChestDefinition;
    private final BlockState skyStone;
    private final Item skyStoneItem;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private final IWorld world;
    private final Fallout type;
    private final BlockPos pos;
    private final int x;
    private final int y;
    private final int z;
    private final double meteoriteSize;
    private final double realCrater;
    private final double squaredMeteoriteSize;
    private final double crater;
    private final boolean placeCrater;
    private final CraterType craterType;
    private final boolean pureCrater;
    private final boolean craterLake;
    private final MutableBoundingBox boundingBox;

    public MeteoritePlacer(IWorld world, PlacedMeteoriteSettings settings, MutableBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        this.world = world;
        this.pos = settings.getPos();
        this.x = settings.getPos().func_177958_n();
        this.y = settings.getPos().func_177956_o();
        this.z = settings.getPos().func_177952_p();
        this.meteoriteSize = settings.getMeteoriteRadius();
        this.realCrater = this.meteoriteSize * 2.0 + 5.0;
        this.placeCrater = settings.shouldPlaceCrater();
        this.craterType = settings.getCraterType();
        this.pureCrater = settings.isPureCrater();
        this.craterLake = settings.isCraterLake();
        this.squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
        this.crater = this.realCrater * this.realCrater;
        IBlocks blocks = Api.instance().definitions().blocks();
        this.skyChestDefinition = blocks.skyStoneChest();
        this.skyStone = blocks.skyStoneBlock().block().func_176223_P();
        this.skyStoneItem = blocks.skyStoneBlock().item();
        this.type = this.getFallout(world, settings.getPos(), settings.getFallout());
    }

    public void place() {
        if (this.placeCrater) {
            this.placeCrater();
        }
        this.placeMeteorite();
        if (this.placeCrater) {
            this.decay();
        }
        if (this.craterLake) {
            this.placeCraterLake();
        }
    }

    private int minX(int x) {
        if (x < this.boundingBox.field_78897_a) {
            return this.boundingBox.field_78897_a;
        }
        if (x > this.boundingBox.field_78893_d) {
            return this.boundingBox.field_78893_d;
        }
        return x;
    }

    private int minZ(int x) {
        if (x < this.boundingBox.field_78896_c) {
            return this.boundingBox.field_78896_c;
        }
        if (x > this.boundingBox.field_78892_f) {
            return this.boundingBox.field_78892_f;
        }
        return x;
    }

    private int maxX(int x) {
        if (x < this.boundingBox.field_78897_a) {
            return this.boundingBox.field_78897_a;
        }
        if (x > this.boundingBox.field_78893_d) {
            return this.boundingBox.field_78893_d;
        }
        return x;
    }

    private int maxZ(int x) {
        if (x < this.boundingBox.field_78896_c) {
            return this.boundingBox.field_78896_c;
        }
        if (x > this.boundingBox.field_78892_f) {
            return this.boundingBox.field_78892_f;
        }
        return x;
    }

    private void placeCrater() {
        int maxY = 255;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        BlockState filler = this.craterType.getFiller().func_176223_P();
        for (int j = this.y - 5; j <= 255; ++j) {
            blockPos.func_185336_p(j);
            for (int i = this.boundingBox.field_78897_a; i <= this.boundingBox.field_78893_d; ++i) {
                blockPos.func_223471_o(i);
                for (int k = this.boundingBox.field_78896_c; k <= this.boundingBox.field_78892_f; ++k) {
                    blockPos.func_223472_q(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02)) continue;
                    BlockState currentBlock = this.world.func_180495_p((BlockPos)blockPos);
                    if (this.craterType != CraterType.NORMAL && j < this.y && currentBlock.func_185904_a().func_76220_a()) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(this.world, (BlockPos)blockPos, filler);
                        continue;
                    }
                    this.putter.put(this.world, (BlockPos)blockPos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (Object o : this.world.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.minX(this.x - 30), (double)(this.y - 5), (double)this.minZ(this.z - 30), (double)this.maxX(this.x + 30), (double)(this.y + 30), (double)this.maxZ(this.z + 30)))) {
            Entity e = (Entity)o;
            e.func_70106_y();
        }
    }

    private void placeMeteorite() {
        this.placeMeteoriteSkyStone();
        this.placeChest();
    }

    private void placeChest() {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.SPAWN_PRESSES_IN_METEORITES)) {
            this.putter.put(this.world, this.pos, this.skyChestDefinition.block().func_176223_P());
            TileEntity te = this.world.func_175625_s(this.pos);
            InventoryAdaptor ap = InventoryAdaptor.getAdaptor(te, Direction.UP);
            if (ap != null && !ap.containsItems()) {
                int primary = Math.max(1, (int)(Math.random() * 4.0));
                if (primary > 3) {
                    primary = 3;
                }
                for (int zz = 0; zz < primary; ++zz) {
                    boolean duplicate;
                    do {
                        duplicate = false;
                        int r = Math.random() > 0.7 ? WorldData.instance().storageData().getNextOrderedValue("presses", 0) : (int)(Math.random() * 1000.0);
                        ItemStack toAdd = ItemStack.field_190927_a;
                        IMaterials materials = Api.instance().definitions().materials();
                        switch (r % 4) {
                            case 0: {
                                toAdd = materials.calcProcessorPress().maybeStack(1).orElse(ItemStack.field_190927_a);
                                break;
                            }
                            case 1: {
                                toAdd = materials.engProcessorPress().maybeStack(1).orElse(ItemStack.field_190927_a);
                                break;
                            }
                            case 2: {
                                toAdd = materials.logicProcessorPress().maybeStack(1).orElse(ItemStack.field_190927_a);
                                break;
                            }
                            case 3: {
                                toAdd = materials.siliconPress().maybeStack(1).orElse(ItemStack.field_190927_a);
                                break;
                            }
                        }
                        if (toAdd.func_190926_b()) continue;
                        if (ap.simulateRemove(1, toAdd, null).func_190926_b()) {
                            ap.addItems(toAdd);
                            continue;
                        }
                        duplicate = true;
                    } while (duplicate);
                }
                int secondary = Math.max(1, (int)(Math.random() * 3.0));
                block12: for (int zz = 0; zz < secondary; ++zz) {
                    switch ((int)(Math.random() * 1000.0) % 3) {
                        case 0: {
                            int amount = (int)(Math.random() * 12.0 + 1.0);
                            ap.addItems(new ItemStack((IItemProvider)this.skyStoneItem, amount));
                            continue block12;
                        }
                        case 1: {
                            ArrayList<ItemStack> possibles = new ArrayList<ItemStack>();
                            possibles.add(new ItemStack((IItemProvider)Items.field_151074_bl));
                            ItemStack nugget = (ItemStack)Platform.pickRandom(possibles);
                            if (nugget == null || nugget.func_190926_b()) continue block12;
                            nugget = nugget.func_77946_l();
                            nugget.func_190920_e((int)(Math.random() * 12.0) + 1);
                            ap.addItems(nugget);
                        }
                    }
                }
            }
        }
    }

    private void placeMeteoriteSkyStone() {
        int meteorXLength = this.minX(this.x - 8);
        int meteorXHeight = this.maxX(this.x + 8);
        int meteorZLength = this.minZ(this.z - 8);
        int meteorZHeight = this.maxZ(this.z + 8);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            pos.func_223471_o(i);
            for (int j = this.y - 8; j < this.y + 8; ++j) {
                pos.func_185336_p(j);
                for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                    pos.func_223472_q(k);
                    double dx = i - this.x;
                    double dy = j - this.y;
                    double dz = k - this.z;
                    double d = j > this.y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.squaredMeteoriteSize)) continue;
                    this.putter.put(this.world, (BlockPos)pos, this.skyStone);
                }
            }
        }
    }

    private void decay() {
        double randomShit = 0.0;
        int meteorXLength = this.minX(this.x - 30);
        int meteorXHeight = this.maxX(this.x + 30);
        int meteorZLength = this.minZ(this.z - 30);
        int meteorZHeight = this.maxZ(this.z + 30);
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        BlockPos.Mutable blockPosUp = new BlockPos.Mutable();
        BlockPos.Mutable blockPosDown = new BlockPos.Mutable();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            blockPos.func_223471_o(i);
            blockPosUp.func_223471_o(i);
            blockPosDown.func_223471_o(i);
            for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                blockPos.func_223472_q(k);
                blockPosUp.func_223472_q(k);
                blockPosDown.func_223472_q(k);
                for (int j = this.y - 9; j < this.y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    blockPos.func_185336_p(j);
                    blockPosUp.func_185336_p(j + 1);
                    blockPosDown.func_185336_p(j - 1);
                    BlockState state = this.world.func_180495_p((BlockPos)blockPos);
                    Block blk = this.world.func_180495_p((BlockPos)blockPos).func_177230_c();
                    if (this.pureCrater && blk == this.craterType.getFiller()) continue;
                    if (state.func_185904_a().func_76222_j()) {
                        if (!this.world.func_175623_d((BlockPos)blockPosUp)) {
                            BlockState stateUp = this.world.func_180495_p((BlockPos)blockPosUp);
                            this.world.func_180501_a((BlockPos)blockPos, stateUp, 3);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx2 = i - this.x;
                        dy = j - this.y;
                        dz = k - this.z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        BlockState xf = this.world.func_180495_p((BlockPos)blockPosDown);
                        if (xf.func_185904_a().func_76222_j()) continue;
                        double extraRange = Math.random() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf.isAir((IBlockReader)this.world, (BlockPos)blockPosDown) || !(height > 0.0) || !(Math.random() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(this.world, (BlockPos)blockPos);
                        continue;
                    }
                    if (!this.world.func_175623_d((BlockPos)blockPosUp) || !(Math.random() > 0.4) || !((dx = (double)(i - this.x)) * dx + (dy = (double)(j - this.y)) * dy + (dz = (double)(k - this.z)) * dz < this.crater * 1.6)) continue;
                    this.type.getRandomInset(this.world, (BlockPos)blockPos);
                }
            }
        }
    }

    private void placeCraterLake() {
        int maxY = this.world.func_181545_F() - 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int j = this.y - 5; j <= maxY; ++j) {
            blockPos.func_185336_p(j);
            for (int i = this.boundingBox.field_78897_a; i <= this.boundingBox.field_78893_d; ++i) {
                blockPos.func_223471_o(i);
                for (int k = this.boundingBox.field_78896_c; k <= this.boundingBox.field_78892_f; ++k) {
                    BlockState currentBlock;
                    blockPos.func_223472_q(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02) || (currentBlock = this.world.func_180495_p((BlockPos)blockPos)).func_177230_c() != Blocks.field_150350_a) continue;
                    this.putter.put(this.world, (BlockPos)blockPos, Blocks.field_150355_j.func_176223_P());
                }
            }
        }
    }

    private Fallout getFallout(IWorld w, BlockPos pos, FalloutMode mode) {
        switch (mode) {
            case SAND: {
                return new FalloutSand(w, pos, this.putter, this.skyStone);
            }
            case TERRACOTTA: {
                return new FalloutCopy(w, pos, this.putter, this.skyStone);
            }
            case ICE_SNOW: {
                return new FalloutSnow(w, pos, this.putter, this.skyStone);
            }
        }
        return new Fallout(this.putter, this.skyStone);
    }
}

