/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks.ticking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.CableRenderMode;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.crafting.CraftingJob;
import appeng.hooks.ticking.PlayerColor;
import appeng.hooks.ticking.ServerGridRepo;
import appeng.hooks.ticking.ServerTileRepo;
import appeng.me.Grid;
import appeng.tile.AEBaseTileEntity;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;

public class TickHandler {
    private static final int TIME_LIMIT_PROCESS_QUEUE_MILLISECONDS = 25;
    private static final TickHandler INSTANCE = new TickHandler();
    private final Queue<IWorldCallable<?>> serverQueue = new ArrayDeque();
    private final Multimap<IWorld, CraftingJob> craftingJobs = LinkedListMultimap.create();
    private final Map<IWorld, Queue<IWorldCallable<?>>> callQueue = new HashMap();
    private final ServerTileRepo tiles = new ServerTileRepo();
    private final ServerGridRepo grids = new ServerGridRepo();
    private final Map<Integer, PlayerColor> cliPlayerColors = new HashMap<Integer, PlayerColor>();
    private final Map<Integer, PlayerColor> srvPlayerColors = new HashMap<Integer, PlayerColor>();
    private CableRenderMode crm = CableRenderMode.STANDARD;
    private final Stopwatch sw = Stopwatch.createUnstarted();
    private int processQueueElementsProcessed = 0;
    private int processQueueElementsRemaining = 0;

    public static TickHandler instance() {
        return INSTANCE;
    }

    private TickHandler() {
    }

    public static void setup(final IEventBus eventBus) {
        eventBus.addListener(INSTANCE::onServerTick);
        eventBus.addListener(INSTANCE::onWorldTick);
        eventBus.addListener(INSTANCE::onUnloadChunk);
        eventBus.addListener(EventPriority.HIGHEST, INSTANCE::onLoadWorld);
        eventBus.addListener(EventPriority.LOWEST, INSTANCE::onUnloadWorld);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 5221919736953944125L;

            public void run() {
                eventBus.addListener(INSTANCE::onClientTick);
            }
        });
    }

    public Map<Integer, PlayerColor> getPlayerColors() {
        if (Platform.isServer()) {
            return this.srvPlayerColors;
        }
        return this.cliPlayerColors;
    }

    public void addCallable(IWorld w, IWorldCallable<?> c) {
        Preconditions.checkArgument((w == null || !w.func_201670_d() ? 1 : 0) != 0, (Object)"Can only register serverside callbacks");
        if (w == null) {
            this.serverQueue.add(c);
        } else {
            Queue<IWorldCallable<?>> queue = this.callQueue.get(w);
            if (queue == null) {
                queue = new ArrayDeque();
                this.callQueue.put(w, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseTileEntity tile) {
        if (!tile.func_145831_w().func_201670_d()) {
            Objects.requireNonNull(tile);
            this.tiles.addTile(tile);
        }
    }

    public void addNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.addNetwork(grid);
    }

    public void removeNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.removeNetwork(grid);
    }

    public Iterable<Grid> getGridList() {
        Platform.assertServerThread();
        return this.grids.getNetworks();
    }

    public void shutdown() {
        Platform.assertServerThread();
        this.tiles.clear();
        this.grids.clear();
    }

    public void onUnloadChunk(ChunkEvent.Unload ev) {
        if (!ev.getWorld().func_201670_d()) {
            this.tiles.removeWorldChunk(ev.getWorld(), ev.getChunk().func_76632_l().func_201841_a());
        }
    }

    public void onLoadWorld(WorldEvent.Load ev) {
        if (!ev.getWorld().func_201670_d()) {
            this.tiles.addWorld(ev.getWorld());
        }
    }

    public void onUnloadWorld(WorldEvent.Unload ev) {
        if (!ev.getWorld().func_201670_d()) {
            ArrayList<IGridNode> toDestroy = new ArrayList<IGridNode>();
            this.grids.updateNetworks();
            for (Grid g : this.grids.getNetworks()) {
                for (IGridNode n : g.getNodes()) {
                    if (n.getWorld() != ev.getWorld()) continue;
                    toDestroy.add(n);
                }
            }
            for (IGridNode n : toDestroy) {
                n.destroy();
            }
            this.tiles.removeWorld(ev.getWorld());
            this.callQueue.remove(ev.getWorld());
        }
    }

    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.tickColors(this.cliPlayerColors);
            CableRenderMode currentMode = Api.instance().partHelper().getCableRenderMode();
            if (currentMode != this.crm) {
                this.crm = currentMode;
                AppEng.proxy.triggerUpdates();
            }
        }
    }

    public void onWorldTick(TickEvent.WorldTickEvent ev) {
        World world = ev.world;
        if (world.field_72995_K || ev.side != LogicalSide.SERVER) {
            return;
        }
        if (ev.phase == TickEvent.Phase.START) {
            Queue<IWorldCallable<?>> queue = this.callQueue.get(world);
            this.processQueueElementsRemaining += this.processQueue(queue, world);
        } else if (ev.phase == TickEvent.Phase.END) {
            this.simulateCraftingJobs((IWorld)world);
            this.readyTiles((IWorld)world);
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.processQueueElementsProcessed = 0;
            this.processQueueElementsRemaining = 0;
            this.sw.reset();
        }
        if (ev.phase == TickEvent.Phase.END) {
            this.tickColors(this.srvPlayerColors);
            this.grids.updateNetworks();
            for (Grid g : this.grids.getNetworks()) {
                g.update();
            }
            this.processQueueElementsRemaining += this.processQueue(this.serverQueue, null);
            if (this.sw.elapsed(TimeUnit.MILLISECONDS) > 25L) {
                AELog.warn("Exceeded time limit of %d ms after processing %d queued tick callbacks (%d remain)", 25, this.processQueueElementsProcessed, this.processQueueElementsRemaining);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(World world, CraftingJob craftingJob) {
        Preconditions.checkArgument((!world.field_72995_K ? 1 : 0) != 0, (Object)"Trying to register a crafting job for a client-world");
        Multimap<IWorld, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateCraftingJobs(IWorld world) {
        Multimap<IWorld, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            Collection jobSet = this.craftingJobs.get((Object)world);
            if (!jobSet.isEmpty()) {
                int jobSize = jobSet.size();
                int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                int simTime = Math.max(1, microSecondsPerTick / jobSize);
                Iterator i = jobSet.iterator();
                while (i.hasNext()) {
                    CraftingJob cj = (CraftingJob)i.next();
                    if (cj.simulateFor(simTime)) continue;
                    i.remove();
                }
            }
        }
    }

    private void readyTiles(IWorld world) {
        long[] workSet;
        AbstractChunkProvider chunkProvider = world.func_72863_F();
        Long2ObjectMap<List<AEBaseTileEntity>> worldQueue = this.tiles.getTiles(world);
        for (long packedChunkPos : workSet = worldQueue.keySet().toLongArray()) {
            ChunkPos chunkPos = new ChunkPos(packedChunkPos);
            BlockPos testBlockPos = new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d());
            if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b) || !chunkProvider.func_222866_a(testBlockPos)) continue;
            List chunkQueue = (List)worldQueue.remove(packedChunkPos);
            if (chunkQueue == null) {
                AELog.warn("Chunk %s was unloaded while we were readying tiles", chunkPos);
                continue;
            }
            for (AEBaseTileEntity bt : chunkQueue) {
                if (bt.func_145837_r()) continue;
                bt.onReady();
            }
        }
    }

    private void tickColors(Map<Integer, PlayerColor> playerSet) {
        Iterator<PlayerColor> i = playerSet.values().iterator();
        while (i.hasNext()) {
            PlayerColor pc = i.next();
            if (pc.isDone()) {
                i.remove();
            }
            pc.tick();
        }
    }

    private int processQueue(Queue<IWorldCallable<?>> queue, World world) {
        if (queue == null) {
            return 0;
        }
        this.sw.start();
        while (!queue.isEmpty()) {
            try {
                queue.poll().call(world);
                ++this.processQueueElementsProcessed;
                if (this.sw.elapsed(TimeUnit.MILLISECONDS) <= 25L) continue;
                break;
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        this.sw.stop();
        return queue.size();
    }
}

