/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import appeng.container.interfaces.IProgressProvider;
import appeng.core.localization.GuiText;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgressBar
extends Widget
implements ITooltip {
    private final IProgressProvider source;
    private final Blitter blitter;
    private final Direction layout;
    private final Rectangle2d sourceRect;
    private final ITextComponent titleName;
    private ITextComponent fullMsg;

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir) {
        this(source, blitter, dir, null);
    }

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir, ITextComponent title) {
        super(0, 0, blitter.getSrcWidth(), blitter.getSrcHeight(), StringTextComponent.field_240750_d_);
        this.source = source;
        this.blitter = blitter.copy();
        this.layout = dir;
        this.titleName = title;
        this.sourceRect = new Rectangle2d(blitter.getSrcX(), blitter.getSrcY(), blitter.getSrcWidth(), blitter.getSrcHeight());
    }

    public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            int srcX = this.sourceRect.func_199318_a();
            int srcY = this.sourceRect.func_199319_b();
            int srcW = this.sourceRect.func_199316_c();
            int srcH = this.sourceRect.func_199317_d();
            int destX = this.field_230690_l_;
            int destY = this.field_230691_m_;
            if (this.layout == Direction.VERTICAL) {
                int diff = this.field_230689_k_ - (max > 0 ? this.field_230689_k_ * current / max : 0);
                destY += diff;
                srcY += diff;
                srcH -= diff;
            } else {
                int diff = this.field_230688_j_ - (max > 0 ? this.field_230688_j_ * current / max : 0);
                srcX += diff;
                srcW -= diff;
            }
            this.blitter.src(srcX, srcY, srcW, srcH).dest(destX, destY).blit(matrices, this.func_230927_p_());
        }
    }

    public void setFullMsg(ITextComponent msg) {
        this.fullMsg = msg;
    }

    @Override
    public List<ITextComponent> getTooltipMessage() {
        if (this.fullMsg != null) {
            return Collections.singletonList(this.fullMsg);
        }
        ITextComponent result = this.titleName != null ? this.titleName : StringTextComponent.field_240750_d_;
        return Arrays.asList(result, new StringTextComponent(this.source.getCurrentProgress() + " ").func_230529_a_((ITextComponent)GuiText.Of.text().func_230532_e_().func_240702_b_(" " + this.source.getMaxProgress())));
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_ - 2;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_ - 2;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.field_230688_j_ + 4;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.field_230689_k_ + 4;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

