/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import net.minecraft.util.Direction;

public enum AEPartLocation {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0),
    INTERNAL(0, 0, 0);

    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    private static final Direction[] facings;
    private static final int[] OPPOSITES;
    public static final AEPartLocation[] SIDE_LOCATIONS;

    private AEPartLocation(int x, int y, int z) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
    }

    public static AEPartLocation fromOrdinal(int id) {
        if (id >= 0 && id < SIDE_LOCATIONS.length) {
            return SIDE_LOCATIONS[id];
        }
        return INTERNAL;
    }

    public static AEPartLocation fromFacing(Direction side) {
        if (side == null) {
            return INTERNAL;
        }
        return AEPartLocation.values()[side.ordinal()];
    }

    public AEPartLocation getOpposite() {
        return AEPartLocation.fromOrdinal(OPPOSITES[this.ordinal()]);
    }

    public Direction getFacing() {
        return facings[this.ordinal()];
    }

    static {
        facings = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
        OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 6};
        SIDE_LOCATIONS = new AEPartLocation[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }
}

