/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected boolean smoothScrolling = true;
    protected final NumberAnimator<Double> scrollAnimator = ValueAnimator.ofDouble();

    public DynamicSmoothScrollingEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double scroll) {
        if (!this.smoothScrolling) {
            this.scrollAnimator.setAs(MathHelper.func_151237_a((double)scroll, (double)0.0, (double)this.getMaxScroll()));
        } else {
            this.scrollAnimator.setAs(ScrollingContainer.clampExtension(scroll, this.getMaxScroll()));
        }
        this.scroll = (Double)this.scrollAnimator.value();
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.smoothScrolling) {
            return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.getFocused() != null && this.func_231041_ay__() && button == 0 && this.getFocused().func_231045_a_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(MathHelper.func_151237_a((double)(this.getScroll() + deltaY * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        for (DynamicEntryListWidget.Entry entry : this.visibleChildren()) {
            if (!entry.func_231043_a_(mouseX, mouseY, amount)) continue;
            return true;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -amount;
            this.scroll = MathHelper.func_151237_a((double)amount, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo((Double)this.scrollAnimator.target() + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        if (animated) {
            this.scrollAnimator.setTo(value, duration);
        } else {
            this.scrollAnimator.setAs(value);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.scrollAnimator.setTarget(ScrollingContainer.handleBounceBack((Double)this.scrollAnimator.target(), this.getMaxScroll(), delta));
        this.scrollAnimator.update(delta);
        this.scroll = (Double)this.scrollAnimator.value();
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void renderScrollBar(MatrixStack matrices, Tessellator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(matrices, tessellator, buffer, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = MathHelper.func_76125_a((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)(minY + height), 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)(minY + height), 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)minY, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)(minY + height - 1), 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)(scrollbarPositionMaxX - 1), (float)(minY + height - 1), 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)(scrollbarPositionMaxX - 1), (float)minY, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

