/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.util;

import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;

public class AnimationUtil {
    static Item crossbow = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "crossbow"));

    public static boolean isUsingboothHands(BipedModel.ArmPose pose) {
        return pose == BipedModel.ArmPose.BOW_AND_ARROW || pose == BipedModel.ArmPose.CROSSBOW_CHARGE || pose == BipedModel.ArmPose.CROSSBOW_HOLD;
    }

    public static boolean isSwingingArm(AbstractClientPlayerEntity player, BodyPart arm) {
        if (!player.field_82175_bq) {
            return false;
        }
        if (arm == BodyPart.LEFT_ARM) {
            return player.func_184591_cq() == HandSide.LEFT && player.field_184622_au == Hand.MAIN_HAND || player.func_184591_cq() == HandSide.RIGHT && player.field_184622_au == Hand.OFF_HAND;
        }
        return player.func_184591_cq() == HandSide.RIGHT && player.field_184622_au == Hand.MAIN_HAND || player.func_184591_cq() == HandSide.LEFT && player.field_184622_au == Hand.OFF_HAND;
    }

    public static BipedModel.ArmPose getArmPose(AbstractClientPlayerEntity abstractClientPlayerEntity, Hand hand) {
        ItemStack itemStack = abstractClientPlayerEntity.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (abstractClientPlayerEntity.func_184600_cs() == hand && abstractClientPlayerEntity.func_184605_cv() > 0) {
            UseAction useAction = itemStack.func_77975_n();
            if (useAction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useAction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAction.CROSSBOW && hand.equals((Object)abstractClientPlayerEntity.func_184600_cs())) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!abstractClientPlayerEntity.field_82175_bq && itemStack.func_77973_b().equals(crossbow) && AnimationUtil.isChargedCrossbow(itemStack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    public static boolean isChargedCrossbow(ItemStack item) {
        return CrossbowItem.func_220012_d((ItemStack)item);
    }

    public static void applyArmTransforms(PlayerModel<AbstractClientPlayerEntity> model, HandSide arm, float pitch, float yaw, float roll) {
        ModelRenderer part = arm == HandSide.RIGHT ? model.field_178723_h : model.field_178724_i;
        part.field_78795_f = pitch;
        part.field_78796_g = yaw;
        if (arm == HandSide.LEFT) {
            part.field_78796_g *= -1.0f;
        }
        part.field_78808_h = roll;
        if (arm == HandSide.LEFT) {
            part.field_78808_h *= -1.0f;
        }
    }

    public static void applyTransforms(PlayerModel<AbstractClientPlayerEntity> model, BodyPart bodyPart, float pitch, float yaw, float roll) {
        boolean mirror = false;
        switch (bodyPart) {
            case LEFT_ARM: {
                mirror = true;
                ModelRenderer part = model.field_178724_i;
                break;
            }
            case RIGHT_ARM: {
                ModelRenderer part = model.field_178723_h;
                break;
            }
            case LEFT_LEG: {
                mirror = true;
                ModelRenderer part = model.field_178722_k;
                break;
            }
            case RIGHT_LEG: {
                ModelRenderer part = model.field_178721_j;
                break;
            }
            default: {
                return;
            }
        }
        part.field_78795_f = pitch;
        part.field_78796_g = yaw;
        if (mirror) {
            part.field_78796_g *= -1.0f;
        }
        part.field_78808_h = roll;
        if (mirror) {
            part.field_78808_h *= -1.0f;
        }
    }

    public static void minMaxHeadRotation(PlayerEntity livingEntity, PlayerModel<AbstractClientPlayerEntity> model) {
        float value = AnimationUtil.legacyWrapDegrees(model.field_78116_c.field_78796_g);
        float min = AnimationUtil.legacyWrapDegrees(model.field_78115_e.field_78796_g - 1.5707964f);
        float max = AnimationUtil.legacyWrapDegrees(model.field_78115_e.field_78796_g + 1.5707964f);
        value = Math.min(value, max);
        model.field_78116_c.field_78796_g = value = Math.max(value, min);
        model.field_178720_f.field_78796_g = value;
    }

    public static float interpolateRotation(float start, float end, float amount) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float diff = wrappedEnd - wrappedStart;
        if (diff > (float)Math.PI) {
            wrappedEnd -= (float)Math.PI * 2;
        } else if (diff < (float)(-Math.PI)) {
            wrappedEnd += (float)Math.PI * 2;
        }
        return AnimationUtil.wrapDegrees(wrappedStart + (wrappedEnd - wrappedStart) * amount);
    }

    public static float lerpAngle(float delta, float start, float end) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float difference = wrappedEnd - wrappedStart;
        float shortestPath = (difference + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return AnimationUtil.wrapDegrees(wrappedStart + shortestPath * delta);
    }

    public static float wrapDegrees(float angle) {
        return (angle + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
    }

    public static float legacyWrapDegrees(float f) {
        float g = f % 6.283185f;
        if (g >= 3.1415925f) {
            g -= 6.283185f;
        }
        if (g < -3.1415925f) {
            g += 6.283185f;
        }
        return g;
    }
}

