/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.renderlayer;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.HandSide;

public class SwordRenderLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private boolean lazyInit = true;
    private static Set<Item> items = new HashSet<Item>();
    private boolean disabled = false;

    public SwordRenderLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderLayerParent) {
        super(renderLayerParent);
    }

    public static void update(PlayerEntity player) {
        PlayerData data = (PlayerData)player;
        if (items.contains(player.func_184614_ca().func_77973_b())) {
            data.setSideSword(player.func_184614_ca());
        }
        if (items.contains(player.func_184592_cb().func_77973_b())) {
            data.setSideSword(player.func_184592_cb());
        }
    }

    public void render(MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int light, AbstractClientPlayerEntity player, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
        boolean wearingArmor;
        if (this.disabled) {
            return;
        }
        if (this.lazyInit) {
            this.lazyInit = false;
            this.init();
        }
        if (!NEABaseMod.config.showLastUsedSword) {
            return;
        }
        if (player.func_82150_aj() || player.func_70608_bn()) {
            return;
        }
        if (!(player instanceof PlayerData)) {
            return;
        }
        if (player.func_184218_aH()) {
            return;
        }
        PlayerData data = (PlayerData)player;
        ItemStack itemStack = data.getSideSword();
        if (itemStack.func_190926_b()) {
            return;
        }
        if (player.func_184614_ca() == itemStack || player.func_184592_cb() == itemStack) {
            return;
        }
        poseStack.func_227860_a_();
        ((PlayerModel)this.func_215332_c()).field_78115_e.func_228307_a_(poseStack);
        boolean lefthanded = player.func_184591_cq() == HandSide.LEFT;
        boolean bl = wearingArmor = !player.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
        if (!player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() && player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() != Items.field_185160_cR) {
            wearingArmor = true;
        }
        double offsetX = wearingArmor ? 0.3 : 0.28;
        float swordRotation = -80.0f;
        if (lefthanded) {
            offsetX *= -1.0;
        }
        poseStack.func_227861_a_(offsetX, 0.85, 0.25);
        poseStack.func_227863_a_(NMSHelper.XP.func_229187_a_(swordRotation));
        poseStack.func_227863_a_(NMSHelper.YP.func_229187_a_(180.0f));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)player, itemStack, lefthanded ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, lefthanded, poseStack, multiBufferSource, light);
        poseStack.func_227865_b_();
    }

    private void init() {
        for (String itemKey : NEABaseMod.config.sheathSwords) {
            Item item;
            if (!itemKey.contains(":") || (item = NMSHelper.getItem(NMSHelper.getResourceLocation(itemKey.split(":")[0], itemKey.split(":")[1]))) == Items.field_190931_a) continue;
            items.add(item);
        }
        try {
            Class.forName("net.backslot.BackSlotMain");
            this.disabled = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

