/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class HorseAnimation
extends BasicAnimation {
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.enableHorseAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        AbstractHorseEntity horse;
        Entity entity2;
        return entity.func_184218_aH() && (entity2 = entity.func_184187_bx()) instanceof AbstractHorseEntity && (horse = (AbstractHorseEntity)entity2).func_110257_ck();
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.bothHands;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 1500;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY) {
            return;
        }
        if (part == BodyPart.LEFT_ARM && AnimationUtil.isSwingingArm(entity, part)) {
            return;
        }
        if (part == BodyPart.RIGHT_ARM && AnimationUtil.isSwingingArm(entity, part)) {
            return;
        }
        HandSide arm = part == BodyPart.LEFT_ARM ? HandSide.LEFT : HandSide.RIGHT;
        AbstractHorseEntity horse = (AbstractHorseEntity)entity.func_184187_bx();
        int id = horse.func_184188_bt().indexOf(entity);
        if (id == 0) {
            float rotation = -MathHelper.func_76134_b((float)(horse.field_184619_aG * 0.3f));
            rotation = (float)((double)rotation * 0.1);
            AnimationUtil.applyArmTransforms(model, arm, -1.1f - rotation, -0.2f, 0.3f);
        }
    }
}

