/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private MatrixStack matrixStack = new MatrixStack();
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(XaeroIcon icon, PlayerEntity player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), false);
            GlStateManager.func_227758_s_((int)this.renderFramebuffer.func_242996_f());
        }
        this.renderFramebuffer.func_147610_a(false);
        GlStateManager.func_227714_e_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)iconWidth, (int)iconWidth);
        this.renderFramebuffer.setFramebufferTexture(icon.getTextureAtlas().getTextureId());
        this.renderFramebuffer.func_147611_b();
        if (this.lastAtlas != icon.getTextureAtlas()) {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)Minecraft.field_142025_a);
            this.lastAtlas = icon.getTextureAtlas();
        }
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)iconWidth, (double)iconWidth, (double)0.0, (double)-1.0, (double)1000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        MatrixStack matrixStack = this.matrixStack;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(iconWidth / 2), (double)(iconWidth / 2), 0.0);
        matrixStack.func_227862_a_(3.0f, 3.0f, 1.0f);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)-5, (int)-5, (int)5, (int)5, (int)-1);
        this.renderer.renderIcon(matrixStack, player, skinTextureLocation);
        matrixStack.func_227865_b_();
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.matrixMode((int)5889);
        Misc.minecraftOrtho(mc, false);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        this.renderFramebuffer.func_147609_e();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.renderFramebuffer.getType(), 36160, mc);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l());
    }
}

