/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDimensionOptions;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapConnectionManager;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;

public class GuiMapSwitching {
    private static final ITextComponent CONNECT_MAP = new TranslationTextComponent("gui.xaero_connect_map");
    private static final ITextComponent DISCONNECT_MAP = new TranslationTextComponent("gui.xaero_disconnect_map");
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private DropDownWidget createdDimensionDropdown;
    private DropDownWidget createdMapDropdown;
    private Button switchingButton;
    private Button multiworldTypeOptionButton;
    private Button renameButton;
    private Button connectButton;
    private Button deleteButton;
    private Button confirmButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, Minecraft field_230706_i_, int field_230708_k_, int field_230709_l_) {
        boolean dimensionDDWasOpen = this.createdDimensionDropdown != null && !this.createdDimensionDropdown.isClosed();
        boolean mapDDWasOpen = this.createdMapDropdown != null && !this.createdMapDropdown.isClosed();
        this.createdDimensionDropdown = null;
        this.createdMapDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        this.settingsDimension = this.mapProcessor.getMapWorld().getFutureDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null;
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, field_230709_l_ - 20, b -> {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canToggleThisScreen()) {
                        return;
                    }
                    this.active = !this.active;
                    mapScreen.func_231158_b_(field_230706_i_, field_230708_k_, field_230709_l_);
                    mapScreen.func_231035_a_((IGuiEventListener)this.switchingButton);
                }
            });
            mapScreen.func_230480_a_(this.switchingButton);
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                if (this.active) {
                    this.createdDimensionDropdown = this.createDimensionDropdown(this.uiPausedOnUpdate, field_230708_k_, mapScreen, field_230706_i_);
                    this.createdMapDropdown = this.createMapDropdown(this.uiPausedOnUpdate, field_230708_k_, mapScreen, field_230706_i_);
                    mapScreen.func_230481_d_(this.createdDimensionDropdown);
                    mapScreen.func_230481_d_(this.createdMapDropdown);
                    if (dimensionDDWasOpen) {
                        this.createdDimensionDropdown.setClosed(false);
                    }
                    if (mapDDWasOpen) {
                        this.createdMapDropdown.setClosed(false);
                    }
                    this.multiworldTypeOptionButton = new TooltipButton(field_230708_k_ / 2 - 90, 24, 180, 20, (ITextComponent)new StringTextComponent(this.getMultiworldTypeButtonMessage()), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (this.isMapSelectionOptionEnabled()) {
                                this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                                b.func_238482_a_((ITextComponent)new StringTextComponent(this.getMultiworldTypeButtonMessage()));
                            }
                        }
                    }, this.settingsDimension.isFutureMultiworldServerBased() ? () -> this.serverSelectionModeBox : () -> this.mapSelectionBox);
                    mapScreen.func_230480_a_(this.multiworldTypeOptionButton);
                    this.renameButton = new Button(field_230708_k_ / 2 + 109, 80, 60, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_rename"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canRenameMap()) {
                                return;
                            }
                            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                            if (currentMultiworld == null) {
                                return;
                            }
                            field_230706_i_.func_147108_a((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, currentMultiworld));
                        }
                    });
                    mapScreen.func_230480_a_(this.renameButton);
                    this.connectButton = new Button(field_230708_k_ / 2 + 109, 102, 60, 20, this.getConnectButtonLabel(), b -> {
                        if (!this.canConnectMap()) {
                            return;
                        }
                        MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
                        if (playerMapKey == null) {
                            return;
                        }
                        MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
                        if (destinationMapKey == null) {
                            return;
                        }
                        String autoMapName = playerMapKey.getNamedString(this.settingsDimension.getMapWorld());
                        String selectedMapName = destinationMapKey.getNamedString(this.settingsDimension.getMapWorld());
                        String connectionDisplayString = autoMapName + "   \u00a7e<=>\u00a7r   " + selectedMapName;
                        MapConnectionManager mapConnections = this.settingsDimension.getMapWorld().getMapConnections();
                        boolean connected = mapConnections.isConnected(playerMapKey, destinationMapKey);
                        BooleanConsumer confirmationConsumer = result -> {
                            if (result) {
                                Object object = this.mapProcessor.uiSync;
                                synchronized (object) {
                                    if (connected) {
                                        mapConnections.removeConnection(playerMapKey, destinationMapKey);
                                    } else {
                                        mapConnections.addConnection(playerMapKey, destinationMapKey);
                                    }
                                    b.func_238482_a_(this.getConnectButtonLabel());
                                    this.settingsDimension.getMapWorld().saveConfig();
                                }
                            }
                            field_230706_i_.func_147108_a((Screen)mapScreen);
                        };
                        if (connected) {
                            field_230706_i_.func_147108_a((Screen)new ConfirmScreen(confirmationConsumer, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_disconnect_from_auto_msg"), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                        } else {
                            field_230706_i_.func_147108_a((Screen)new ConfirmScreen(confirmationConsumer, (ITextComponent)new TranslationTextComponent("gui.xaero_wm_connect_with_auto_msg"), (ITextComponent)new StringTextComponent(connectionDisplayString)));
                        }
                    });
                    mapScreen.func_230480_a_(this.connectButton);
                    this.deleteButton = new Button(field_230708_k_ / 2 - 168, 80, 60, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_delete"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canDeleteMap()) {
                                return;
                            }
                            String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                            field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
                                if (result) {
                                    String mapNameAndIdLine = I18n.func_135052_a((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                    field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result2 -> {
                                        if (result2) {
                                            Object object = this.mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Delayed map deletion!");
                                                        }
                                                        this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Instant map deletion!");
                                                        }
                                                        this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    this.settingsDimension.saveConfigUnsynced();
                                                    this.settingsDimension.futureMultiworldWritable = false;
                                                }
                                            }
                                        }
                                        field_230706_i_.func_147108_a((Screen)mapScreen);
                                    }, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg3"), (ITextComponent)new StringTextComponent(mapNameAndIdLine)));
                                } else {
                                    field_230706_i_.func_147108_a((Screen)mapScreen);
                                }
                            }, (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg1"), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_map_msg2")));
                        }
                    });
                    mapScreen.func_230480_a_(this.deleteButton);
                    this.confirmButton = new Button(field_230708_k_ / 2 - 50, 104, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canConfirm()) {
                                return;
                            }
                            this.confirm(mapScreen, field_230706_i_, field_230708_k_, field_230709_l_);
                        }
                    });
                    mapScreen.func_230480_a_(this.confirmButton);
                    this.updateButtons(mapScreen, field_230708_k_, field_230706_i_);
                } else {
                    this.switchingButton.field_230693_o_ = this.canToggleThisScreen();
                }
            } else {
                this.switchingButton.field_230693_o_ = false;
            }
        }
    }

    public static GuiDimensionOptions getSortedDimensionOptions(MapDimension dim) {
        int selected = 0;
        RegistryKey<World> currentDim = dim.getDimId();
        ArrayList sortableList = new ArrayList();
        for (MapDimension dimension : dim.getMapWorld().getDimensionsList()) {
            sortableList.add(new KeySortableByOther<RegistryKey<World>>(dimension.getDimId(), new Comparable[]{dimension.getDimId().func_240901_a_().toString()}));
        }
        Collections.sort(sortableList);
        selected = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentDim);
        RegistryKey[] values = new RegistryKey[]{};
        values = sortableList.stream().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll).toArray(values);
        return new GuiDimensionOptions(selected, values);
    }

    private DropDownWidget createDimensionDropdown(boolean paused, int width, GuiMap mapScreen, Minecraft minecraft) {
        GuiDimensionOptions dimOptions = GuiMapSwitching.getSortedDimensionOptions(this.settingsDimension);
        ArrayList<String> dropdownLabels = new ArrayList<String>();
        RegistryKey currentWorldDim = this.mapProcessor.getWorld() == null ? null : this.mapProcessor.getWorld().func_234923_W_();
        for (RegistryKey<World> k : dimOptions.values) {
            String result = k.func_240901_a_().toString();
            if (result.startsWith("minecraft:")) {
                result = result.substring(10);
            }
            if (k == currentWorldDim) {
                result = result + " (auto)";
            }
            dropdownLabels.add(result);
        }
        RegistryKey<World>[] finalValues = dimOptions.values;
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(dropdownLabels.toArray(new String[0])).setX(width / 2 - 100).setY(64).setW(200).setSelected(dimOptions.selected).setCallback((dd, i) -> {
            RegistryKey selectedValue = finalValues[i];
            this.settingsDimension = this.settingsDimension.getMapWorld().getDimension((RegistryKey<World>)selectedValue);
            if (selectedValue == currentWorldDim) {
                selectedValue = null;
            }
            this.settingsDimension.getMapWorld().setCustomDimensionId((RegistryKey<World>)selectedValue);
            this.mapProcessor.checkForWorldUpdate();
            DropDownWidget newDropDown = this.createMapDropdown(this.uiPausedOnUpdate, width, mapScreen, minecraft);
            mapScreen.replaceWidget(this.createdMapDropdown, newDropDown);
            this.createdMapDropdown = newDropDown;
            this.updateButtons(mapScreen, width, minecraft);
            return true;
        }).setContainer(mapScreen).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui_xaero_wm_dropdown_dimension_select")).build();
        return result;
    }

    private DropDownWidget createMapDropdown(boolean paused, int width, GuiMap mapScreen, Minecraft minecraft) {
        List<String> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            int currentIndex;
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList sortableList = new ArrayList();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther<String>(mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            if (currentMultiworld != null && (currentIndex = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentMultiworld)) == -1) {
                sortableList.add(new KeySortableByOther<String>(currentMultiworld, new Comparable[]{this.settingsDimension.getMultiworldName(currentMultiworld).toLowerCase()}));
            }
            Collections.sort(sortableList);
            if (currentMultiworld != null) {
                selected = GuiMapSwitching.getDropdownSelectionIdFromValue(sortableList, currentMultiworld);
            }
            this.mwDropdownValues = sortableList.stream().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll).toArray(new String[0]);
            mwDropdownNames = sortableList.stream().map(KeySortableByOther::getKey).map(this.settingsDimension::getMultiworldName).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            mwDropdownNames.add("\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
        } else {
            mwDropdownNames = new ArrayList<String>();
            this.mwDropdownValues = null;
            mwDropdownNames.add("\u00a77" + I18n.func_135052_a((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]));
        }
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(mwDropdownNames.toArray(new String[0])).setX(width / 2 - 100).setY(84).setW(200).setSelected(selected).setCallback((dd, i) -> {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.isUIPaused() || this.uiPausedOnUpdate) {
                    return false;
                }
                if (i < this.mwDropdownValues.length) {
                    this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                    this.updateButtons(mapScreen, width, minecraft);
                    return true;
                }
                minecraft.func_147108_a((Screen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                return false;
            }
        }).setContainer(mapScreen).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui_xaero_wm_dropdown_map_select")).build();
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureUsingWorldSaveUnsynced() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureUsingWorldSaveUnsynced();
    }

    private boolean canConnectMap() {
        if (!this.mapProcessor.getMapWorld().isMultiplayer()) {
            return false;
        }
        MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
        if (playerMapKey == null) {
            return false;
        }
        MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
        if (destinationMapKey == null) {
            return false;
        }
        return !destinationMapKey.equals(playerMapKey);
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITextComponent getConnectButtonLabel() {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            if (this.isUIPaused()) {
                return CONNECT_MAP;
            }
            MapConnectionNode playerMapKey = this.settingsDimension.getMapWorld().getPlayerMapKey();
            if (playerMapKey == null) {
                return CONNECT_MAP;
            }
            MapConnectionNode destinationMapKey = this.settingsDimension.getSelectedMapKeyUnsynced();
            if (destinationMapKey == null) {
                return CONNECT_MAP;
            }
            MapConnectionManager mapConnections = this.settingsDimension.getMapWorld().getMapConnections();
            if (mapConnections.isConnected(playerMapKey, destinationMapKey)) {
                return DISCONNECT_MAP;
            }
            return CONNECT_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(GuiMap mapScreen, int width, Minecraft minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                DropDownWidget newDropDown;
                DropDownWidget dropDownWidget = newDropDown = !this.active ? null : this.createMapDropdown(isPaused, width, mapScreen, minecraft);
                if (newDropDown != null) {
                    if (this.createdMapDropdown != null) {
                        mapScreen.replaceWidget(this.createdMapDropdown, newDropDown);
                    } else {
                        mapScreen.func_230481_d_(newDropDown);
                    }
                } else if (this.createdMapDropdown != null) {
                    mapScreen.removeWidget(this.createdMapDropdown);
                }
                this.createdMapDropdown = !this.active ? null : newDropDown;
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.field_230693_o_ = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.field_230693_o_ = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.field_230693_o_ = this.canRenameMap();
            }
            if (this.connectButton != null) {
                this.connectButton.field_230693_o_ = this.canConnectMap();
                this.connectButton.func_238482_a_(this.getConnectButtonLabel());
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.field_230693_o_ = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.field_230693_o_ = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.func_135052_a((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.func_231158_b_(minecraft, width, height);
        }
    }

    private static <S> int getDropdownSelectionIdFromValue(List<KeySortableByOther<S>> values, S value) {
        for (int selected = 0; selected < values.size(); ++selected) {
            if (!values.get(selected).getKey().equals(value)) continue;
            return selected;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.func_231158_b_(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdMapDropdown == null || this.createdMapDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && this.createdMapDropdown.isClosed() && !this.uiPausedOnUpdate && (currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()) != null && (!currentMultiworld.equals(currentDropdownSelection = this.mwDropdownValues[this.createdMapDropdown.getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.func_231158_b_(minecraft, width, height);
        }
    }

    public void renderText(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.func_135052_a((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        IRenderTypeBuffer.Impl renderTypeBuffers = this.mapProcessor.getCvc().getRenderTypeBuffers();
        IVertexBuilder backgroundVertexBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_COLOR_OVERLAY);
        MapRenderHelper.drawStringWithBackground(matrixStack, minecraft.field_71466_p, selectMapString, width / 2 - minecraft.field_71466_p.func_78256_a(selectMapString) / 2, 49, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
        renderTypeBuffers.func_228461_a_();
    }

    public void postMapRender(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

