/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.AllPaletteBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class RemapHelper {
    private static final Map<String, ResourceLocation> reMap = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("create")) {
            if (!reMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Create.LOGGER.warn("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)reMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.BLOCKS.getValue(reMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Create.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)mapping.key, (Object)reMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("create")) {
            if (!reMap.containsKey(mapping.key.func_110623_a())) continue;
            try {
                Create.LOGGER.warn("Remapping item '{}' to '{}'", (Object)mapping.key, (Object)reMap.get(mapping.key.func_110623_a()));
                mapping.remap(ForgeRegistries.ITEMS.getValue(reMap.get(mapping.key.func_110623_a())));
            }
            catch (Throwable t) {
                Create.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)mapping.key, (Object)reMap.get(mapping.key.func_110623_a()), (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapFluids(RegistryEvent.MissingMappings<Fluid> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("create")) {
            if (mapping.key.func_110623_a().equals("milk")) {
                mapping.remap(ForgeMod.MILK.get());
                continue;
            }
            if (!mapping.key.func_110623_a().equals("flowing_milk")) continue;
            mapping.remap(ForgeMod.FLOWING_MILK.get());
        }
    }

    static {
        reMap.put("toggle_latch", AllBlocks.POWERED_TOGGLE_LATCH.getId());
        reMap.put("encased_shaft", AllBlocks.ANDESITE_ENCASED_SHAFT.getId());
        reMap.put("encased_belt", AllBlocks.ENCASED_CHAIN_DRIVE.getId());
        reMap.put("adjustable_pulley", AllBlocks.ADJUSTABLE_CHAIN_GEARSHIFT.getId());
        reMap.put("limestone_stairs", Create.asResource("polished_limestone_stairs"));
        reMap.put("weathered_limestone_layers", Create.asResource("layered_weathered_limestone"));
        reMap.put("stockswitch", AllBlocks.STOCKPILE_SWITCH.getId());
        reMap.put("indented_gabbro_slab", Create.asResource("polished_gabbro_slab"));
        reMap.put("andesite_layers", Create.asResource("layered_andesite"));
        reMap.put("scoria_layers", Create.asResource("layered_scoria"));
        reMap.put("dark_scoria_tiles_stairs", Create.asResource("dark_scoria_bricks_stairs"));
        reMap.put("redstone_latch", AllBlocks.POWERED_LATCH.getId());
        reMap.put("oak_glass", AllPaletteBlocks.OAK_WINDOW.getId());
        reMap.put("spruce_glass_pane", AllPaletteBlocks.SPRUCE_WINDOW_PANE.getId());
        reMap.put("dolomite_stairs", Create.asResource("polished_dolomite_stairs"));
        reMap.put("contact", AllBlocks.REDSTONE_CONTACT.getId());
        reMap.put("paved_gabbro_bricks", Create.asResource("paved_gabbro"));
        reMap.put("slightly_mossy_gabbro_bricks", Create.asResource("mossy_gabbro"));
        reMap.put("limestone_wall", Create.asResource("polished_limestone_wall"));
        reMap.put("acacia_glass_pane", AllPaletteBlocks.ACACIA_WINDOW_PANE.getId());
        reMap.put("dark_oak_glass", AllPaletteBlocks.DARK_OAK_WINDOW.getId());
        reMap.put("dark_oak_glass_pane", AllPaletteBlocks.DARK_OAK_WINDOW_PANE.getId());
        reMap.put("belt_funnel", AllBlocks.BRASS_BELT_FUNNEL.getId());
        reMap.put("dark_scoria_tiles", Create.asResource("dark_scoria_bricks"));
        reMap.put("acacia_glass", AllPaletteBlocks.ACACIA_WINDOW.getId());
        reMap.put("dark_scoria_tiles_slab", Create.asResource("dark_scoria_bricks_slab"));
        reMap.put("weathered_limestone_stairs", Create.asResource("polished_weathered_limestone_stairs"));
        reMap.put("dolomite_layers", Create.asResource("layered_dolomite"));
        reMap.put("jungle_glass", AllPaletteBlocks.JUNGLE_WINDOW.getId());
        reMap.put("iron_glass", AllPaletteBlocks.ORNATE_IRON_WINDOW.getId());
        reMap.put("limestone_slab", Create.asResource("polished_limestone_slab"));
        reMap.put("entity_detector", AllBlocks.CONTENT_OBSERVER.getId());
        reMap.put("flexcrate", AllBlocks.ADJUSTABLE_CRATE.getId());
        reMap.put("scoria_slab", Create.asResource("polished_scoria_slab"));
        reMap.put("birch_glass", AllPaletteBlocks.BIRCH_WINDOW.getId());
        reMap.put("saw", AllBlocks.MECHANICAL_SAW.getId());
        reMap.put("flexpulsepeater", AllBlocks.ADJUSTABLE_PULSE_REPEATER.getId());
        reMap.put("dolomite_wall", Create.asResource("polished_dolomite_wall"));
        reMap.put("gabbro_layers", Create.asResource("layered_gabbro"));
        reMap.put("scoria_wall", Create.asResource("polished_scoria_wall"));
        reMap.put("stress_gauge", AllBlocks.STRESSOMETER.getId());
        reMap.put("gabbro_slab", Create.asResource("polished_gabbro_slab"));
        reMap.put("spruce_glass", AllPaletteBlocks.SPRUCE_WINDOW.getId());
        reMap.put("iron_glass_pane", AllPaletteBlocks.ORNATE_IRON_WINDOW_PANE.getId());
        reMap.put("birch_glass_pane", AllPaletteBlocks.BIRCH_WINDOW_PANE.getId());
        reMap.put("harvester", AllBlocks.MECHANICAL_HARVESTER.getId());
        reMap.put("dolomite_slab", Create.asResource("polished_dolomite_slab"));
        reMap.put("plough", AllBlocks.MECHANICAL_PLOUGH.getId());
        reMap.put("mossy_gabbro_bricks", Create.asResource("overgrown_gabbro"));
        reMap.put("paved_gabbro_bricks_slab", Create.asResource("paved_gabbro_slab"));
        reMap.put("gabbro_wall", Create.asResource("polished_gabbro_wall"));
        reMap.put("granite_layers", Create.asResource("layered_granite"));
        reMap.put("indented_gabbro", Create.asResource("polished_gabbro"));
        reMap.put("drill", AllBlocks.MECHANICAL_DRILL.getId());
        reMap.put("flexpeater", AllBlocks.ADJUSTABLE_REPEATER.getId());
        reMap.put("rotation_chassis", AllBlocks.RADIAL_CHASSIS.getId());
        reMap.put("scoria_stairs", Create.asResource("polished_scoria_stairs"));
        reMap.put("weathered_limestone_wall", Create.asResource("polished_weathered_limestone_wall"));
        reMap.put("belt_tunnel", AllBlocks.BRASS_TUNNEL.getId());
        reMap.put("redstone_bridge", AllBlocks.REDSTONE_LINK.getId());
        reMap.put("speed_gauge", AllBlocks.SPEEDOMETER.getId());
        reMap.put("diorite_layers", Create.asResource("layered_diorite"));
        reMap.put("oak_glass_pane", AllPaletteBlocks.OAK_WINDOW_PANE.getId());
        reMap.put("translation_chassis", AllBlocks.LINEAR_CHASSIS.getId());
        reMap.put("weathered_limestone_slab", Create.asResource("polished_weathered_limestone_slab"));
        reMap.put("gabbro_stairs", Create.asResource("polished_gabbro_stairs"));
        reMap.put("limestone_layers", Create.asResource("layered_limestone"));
        reMap.put("translation_chassis_secondary", AllBlocks.SECONDARY_LINEAR_CHASSIS.getId());
        reMap.put("jungle_glass_pane", AllPaletteBlocks.JUNGLE_WINDOW_PANE.getId());
        reMap.put("piston_pole", AllBlocks.PISTON_EXTENSION_POLE.getId());
        reMap.put("crushed_copper", AllItems.CRUSHED_COPPER.getId());
        reMap.put("empty_blueprint", AllItems.SCHEMATIC.getId());
        reMap.put("gold_sheet", AllItems.GOLDEN_SHEET.getId());
        reMap.put("flour", AllItems.WHEAT_FLOUR.getId());
        reMap.put("blueprint_and_quill", AllItems.SCHEMATIC_AND_QUILL.getId());
        reMap.put("crushed_iron", AllItems.CRUSHED_IRON.getId());
        reMap.put("slot_cover", AllItems.CRAFTER_SLOT_COVER.getId());
        reMap.put("blueprint", AllItems.SCHEMATIC.getId());
        reMap.put("symmetry_wand", AllItems.WAND_OF_SYMMETRY.getId());
        reMap.put("terrain_zapper", AllItems.WORLDSHAPER.getId());
        reMap.put("crushed_zinc", AllItems.CRUSHED_ZINC.getId());
        reMap.put("property_filter", AllItems.ATTRIBUTE_FILTER.getId());
        reMap.put("crushed_gold", AllItems.CRUSHED_GOLD.getId());
        reMap.put("obsidian_dust", AllItems.POWDERED_OBSIDIAN.getId());
    }
}

