/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.CConfigureConfigPacket;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigHelper {
    public static final Pattern unitPattern = Pattern.compile("\\[(in .*)]");
    public static final Pattern annotationPattern = Pattern.compile("\\[@cui:([^:]*)(?::(.*))?]");
    public static final Map<String, ConfigChange> changes = new HashMap<String, ConfigChange>();
    private static final LoadingCache<String, EnumMap<ModConfig.Type, ModConfig>> configCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, EnumMap<ModConfig.Type, ModConfig>>(){

        public EnumMap<ModConfig.Type, ModConfig> load(@Nonnull String key) {
            return ConfigHelper.findModConfigsUncached(key);
        }
    });

    private static EnumMap<ModConfig.Type, ModConfig> findModConfigsUncached(String modID) {
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modID).orElseThrow(() -> new IllegalArgumentException("Unable to find ModContainer for id: " + modID));
        EnumMap configs = (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)modContainer, (String)"configs");
        return Objects.requireNonNull(configs);
    }

    public static ForgeConfigSpec findConfigSpecFor(ModConfig.Type type, String modID) {
        if (!modID.equals("create")) {
            return ((ModConfig)((EnumMap)configCache.getUnchecked((Object)modID)).get(type)).getSpec();
        }
        switch (type) {
            case COMMON: {
                return AllConfigs.COMMON.specification;
            }
            case CLIENT: {
                return AllConfigs.CLIENT.specification;
            }
            case SERVER: {
                return AllConfigs.SERVER.specification;
            }
        }
        return null;
    }

    public static boolean hasAnyConfig(String modID) {
        EnumMap map = (EnumMap)configCache.getUnchecked((Object)modID);
        return map.entrySet().size() > 0;
    }

    public static <T> void setConfigValue(ConfigPath path, String value) throws InvalidValueException {
        ForgeConfigSpec.ConfigValue configValue;
        Object v;
        List<String> pathList;
        ForgeConfigSpec spec = ConfigHelper.findConfigSpecFor(path.getType(), path.getModID());
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(pathList = Arrays.asList(path.getPath()));
        if (!valueSpec.test(v = CConfigureConfigPacket.deserialize((configValue = (ForgeConfigSpec.ConfigValue)spec.getValues().get(pathList)).get(), value))) {
            throw new InvalidValueException();
        }
        configValue.set(v);
    }

    public static <T> void setValue(String path, ForgeConfigSpec.ConfigValue<T> configValue, T value, @Nullable Map<String, String> annotations) {
        if (value.equals(configValue.get())) {
            changes.remove(path);
        } else {
            changes.put(path, annotations == null ? new ConfigChange(value) : new ConfigChange(value, annotations));
        }
    }

    public static <T> T getValue(String path, ForgeConfigSpec.ConfigValue<T> configValue) {
        ConfigChange configChange = changes.get(path);
        if (configChange != null) {
            return (T)configChange.value;
        }
        return (T)configValue.get();
    }

    public static Pair<String, Map<String, String>> readMetadataFromComment(List<String> commentLines) {
        AtomicReference unit = new AtomicReference();
        HashMap annotations = new HashMap();
        commentLines.removeIf(line -> {
            if (line.trim().isEmpty()) {
                return true;
            }
            Matcher matcher = annotationPattern.matcher((CharSequence)line);
            if (matcher.matches()) {
                String annotation = matcher.group(1);
                String aValue = matcher.group(2);
                annotations.putIfAbsent(annotation, aValue);
                return true;
            }
            matcher = unitPattern.matcher((CharSequence)line);
            if (matcher.matches()) {
                unit.set(matcher.group(1));
            }
            return false;
        });
        return Pair.of(unit.get(), annotations);
    }

    public static class InvalidValueException
    extends Exception {
    }

    public static class ConfigChange {
        Object value;
        Map<String, String> annotations;

        ConfigChange(Object value) {
            this.value = value;
        }

        ConfigChange(Object value, Map<String, String> annotations) {
            this(value);
            this.annotations = new HashMap<String, String>();
            this.annotations.putAll(annotations);
        }
    }

    public static class ConfigPath {
        private String modID = "create";
        private ModConfig.Type type = ModConfig.Type.CLIENT;
        private String[] path;

        public static ConfigPath parse(String string) {
            ConfigPath cp = new ConfigPath();
            String p = string;
            int index = string.indexOf(":");
            if (index >= 0) {
                p = string.substring(index + 1);
                if (index >= 1) {
                    cp.modID = string.substring(0, index);
                }
            }
            String[] split = p.split("\\.");
            try {
                cp.type = ModConfig.Type.valueOf((String)split[0].toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("path must start with either 'client.', 'common.' or 'server.'");
            }
            cp.path = new String[split.length - 1];
            System.arraycopy(split, 1, cp.path, 0, cp.path.length);
            return cp;
        }

        public ConfigPath setID(String modID) {
            this.modID = modID;
            return this;
        }

        public ConfigPath setType(ModConfig.Type type) {
            this.type = type;
            return this;
        }

        public ConfigPath setPath(String[] path) {
            this.path = path;
            return this;
        }

        public String getModID() {
            return this.modID;
        }

        public ModConfig.Type getType() {
            return this.type;
        }

        public String[] getPath() {
            return this.path;
        }
    }
}

