/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AttributeFilterContainer
extends AbstractFilterContainer {
    WhitelistMode whitelistMode;
    List<Pair<ItemAttribute, Boolean>> selectedAttributes;

    public AttributeFilterContainer(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer extraData) {
        super(type, id, inv, extraData);
    }

    public AttributeFilterContainer(ContainerType<?> type, int id, PlayerInventory inv, ItemStack stack) {
        super(type, id, inv, stack);
    }

    public static AttributeFilterContainer create(int id, PlayerInventory inv, ItemStack stack) {
        return new AttributeFilterContainer((ContainerType)AllContainerTypes.ATTRIBUTE_FILTER.get(), id, inv, stack);
    }

    public void appendSelectedAttribute(ItemAttribute itemAttribute, boolean inverted) {
        this.selectedAttributes.add(Pair.of(itemAttribute, inverted));
    }

    @Override
    protected void init(PlayerInventory inv, ItemStack contentHolder) {
        super.init(inv, contentHolder);
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151057_cb);
        stack.func_200302_a((ITextComponent)new StringTextComponent("Selected Tags").func_240701_a_(new TextFormatting[]{TextFormatting.RESET, TextFormatting.BLUE}));
        this.ghostInventory.setStackInSlot(1, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 105;
    }

    @Override
    protected void addFilterSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 16, 22));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 1, 22, 57){

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        });
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    @Override
    public void clearContents() {
        this.selectedAttributes.clear();
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId == 37) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public boolean func_94531_b(Slot slotIn) {
        if (slotIn.field_75222_d == 37) {
            return false;
        }
        return super.func_94531_b(slotIn);
    }

    @Override
    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        if (slotIn.field_75222_d == 37) {
            return false;
        }
        return super.func_94530_a(stack, slotIn);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (index == 37) {
            return ItemStack.field_190927_a;
        }
        if (index == 36) {
            this.ghostInventory.setStackInSlot(37, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.func_70301_a(index);
            ItemStack copy = stackToInsert.func_77946_l();
            copy.func_190920_e(1);
            this.ghostInventory.setStackInSlot(0, copy);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory(filterItem);
        this.selectedAttributes = new ArrayList<Pair<ItemAttribute, Boolean>>();
        this.whitelistMode = WhitelistMode.values()[filterItem.func_196082_o().func_74762_e("WhitelistMode")];
        ListNBT attributes = filterItem.func_196082_o().func_150295_c("MatchedAttributes", 10);
        attributes.forEach(inbt -> {
            CompoundNBT compound = (CompoundNBT)inbt;
            this.selectedAttributes.add(Pair.of(ItemAttribute.fromNBT(compound), compound.func_74767_n("Inverted")));
        });
    }

    @Override
    protected void saveData(ItemStack filterItem) {
        super.saveData(filterItem);
        filterItem.func_196082_o().func_74768_a("WhitelistMode", this.whitelistMode.ordinal());
        ListNBT attributes = new ListNBT();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            CompoundNBT compoundNBT = new CompoundNBT();
            ((ItemAttribute)at.getFirst()).serializeNBT(compoundNBT);
            compoundNBT.func_74757_a("Inverted", ((Boolean)at.getSecond()).booleanValue());
            attributes.add((Object)compoundNBT);
        });
        filterItem.func_196082_o().func_218657_a("MatchedAttributes", (INBT)attributes);
    }

    public static enum WhitelistMode {
        WHITELIST_DISJ,
        WHITELIST_CONJ,
        BLACKLIST;

    }
}

