/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbinePowerTap;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.phosphophyllite.energy.EnergyStorageWrapper;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;
import net.roguelogix.phosphophyllite.multiblock.generic.MultiblockController;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;
import net.roguelogix.phosphophyllite.registry.TileSupplier;

@RegisterTileEntity(name="turbine_power_tap")
public class TurbinePowerTapTile
extends TurbineBaseTile
implements IPhosphophylliteEnergyStorage {
    @RegisterTileEntity.Type
    public static TileEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final TileSupplier SUPPLIER;
    private boolean connected = false;
    Direction powerOutputDirection = null;
    private static final EnergyStorage ENERGY_ZERO;
    @Nonnull
    LazyOptional<?> outputOptional = LazyOptional.empty();
    IPhosphophylliteEnergyStorage output;

    public TurbinePowerTapTile() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    private void setConnected(boolean newState) {
        if (newState != this.connected) {
            this.connected = newState;
            assert (this.field_145850_b != null);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(TurbinePowerTap.ConnectionState.CONNECTION_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.connected ? TurbinePowerTap.ConnectionState.CONNECTED : TurbinePowerTap.ConnectionState.DISCONNECTED))));
        }
    }

    public long distributePower(long toDistribute, boolean simulate) {
        if (this.outputOptional.isPresent()) {
            return this.output.insertEnergy(toDistribute, simulate);
        }
        return 0L;
    }

    public long insertEnergy(long maxInsert, boolean simulate) {
        return 0L;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (this.controller == null || ((TurbineMultiblockController)this.controller).assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long toExtract = ((TurbineMultiblockController)this.controller).simulation().battery().stored();
        toExtract = Math.min(maxExtract, toExtract);
        if (!simulate) {
            toExtract = ((TurbineMultiblockController)this.controller).simulation().battery().extract(toExtract);
        }
        return toExtract;
    }

    public long energyStored() {
        if (this.controller != null) {
            return ((TurbineMultiblockController)this.controller).simulation().battery().stored();
        }
        return 0L;
    }

    public long maxEnergyStored() {
        if (this.controller != null) {
            return ((TurbineMultiblockController)this.controller).simulation().battery().capacity();
        }
        return 0L;
    }

    public boolean canInsert() {
        return false;
    }

    public boolean canExtract() {
        return true;
    }

    public void updateOutputDirection() {
        if (((TurbineMultiblockController)this.controller).assemblyState() == MultiblockController.AssemblyState.DISASSEMBLED) {
            this.powerOutputDirection = null;
        } else if (this.field_174879_c.func_177958_n() == ((TurbineMultiblockController)this.controller).minCoord().x()) {
            this.powerOutputDirection = Direction.WEST;
        } else if (this.field_174879_c.func_177958_n() == ((TurbineMultiblockController)this.controller).maxCoord().x()) {
            this.powerOutputDirection = Direction.EAST;
        } else if (this.field_174879_c.func_177956_o() == ((TurbineMultiblockController)this.controller).minCoord().y()) {
            this.powerOutputDirection = Direction.DOWN;
        } else if (this.field_174879_c.func_177956_o() == ((TurbineMultiblockController)this.controller).maxCoord().y()) {
            this.powerOutputDirection = Direction.UP;
        } else if (this.field_174879_c.func_177952_p() == ((TurbineMultiblockController)this.controller).minCoord().z()) {
            this.powerOutputDirection = Direction.NORTH;
        } else if (this.field_174879_c.func_177952_p() == ((TurbineMultiblockController)this.controller).maxCoord().z()) {
            this.powerOutputDirection = Direction.SOUTH;
        }
        this.neighborChanged();
    }

    public void neighborChanged() {
        this.outputOptional = LazyOptional.empty();
        this.output = null;
        if (this.powerOutputDirection == null) {
            this.setConnected(false);
            return;
        }
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.powerOutputDirection));
        if (te == null) {
            this.setConnected(false);
            return;
        }
        LazyOptional energyOptional = te.getCapability(CapabilityEnergy.ENERGY, this.powerOutputDirection.func_176734_d());
        this.setConnected(energyOptional.isPresent());
        if (this.connected) {
            this.outputOptional = energyOptional;
            this.output = EnergyStorageWrapper.wrap((IEnergyStorage)((IEnergyStorage)energyOptional.orElse((Object)ENERGY_ZERO)));
        }
    }

    static {
        SUPPLIER = TurbinePowerTapTile::new;
        ENERGY_ZERO = new EnergyStorage(0);
    }
}

