/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonButton;
import net.roguelogix.biggerreactors.client.TextBox;
import net.roguelogix.biggerreactors.fluids.FluidYellorium;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorControlRodState;
import net.roguelogix.phosphophyllite.gui.client.RenderHelper;
import net.roguelogix.phosphophyllite.gui.client.ScreenBase;
import net.roguelogix.phosphophyllite.gui.client.elements.AbstractElement;
import net.roguelogix.phosphophyllite.gui.client.elements.Button;
import net.roguelogix.phosphophyllite.gui.client.elements.Symbol;

@OnlyIn(value=Dist.CLIENT)
public class ReactorControlRodScreen
extends ScreenBase<ReactorControlRodContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_control_rod.png");
    private ReactorControlRodState reactorControlRodState = (ReactorControlRodState)((ReactorControlRodContainer)this.func_212873_a_()).getGuiPacket();

    public ReactorControlRodScreen(ReactorControlRodContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title, DEFAULT_TEXTURE, 136, 126);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = this.getWidth() / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.func_231171_q_()) / 2;
        this.initControls();
        this.initGauges();
    }

    public void initControls() {
        TextBox<ReactorControlRodContainer> textBox = new TextBox<ReactorControlRodContainer>(this, this.field_230712_o_, 6, 26, 96, 16, this.reactorControlRodState.name);
        this.addElement((AbstractElement)textBox);
        Button textBoxEnterButton = new Button((ScreenBase)this, 114, 27, 17, 14, 194, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_control_rod.apply.tooltip"));
        textBoxEnterButton.onMouseReleased = (mX, mY, btn) -> {
            if (textBoxEnterButton.func_231047_b_(mX, mY)) {
                ((ReactorControlRodContainer)this.func_212873_a_()).executeRequest("setName", textBox.getContents());
                textBoxEnterButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        textBoxEnterButton.onRender = (mS, mX, mY) -> {
            if (textBoxEnterButton.func_231047_b_((double)mX, (double)mY)) {
                textBoxEnterButton.blit(mS, 211, 0);
            } else {
                textBoxEnterButton.blit(mS, 194, 0);
            }
        };
        CommonButton<ReactorControlRodContainer> textEnterButton = new CommonButton<ReactorControlRodContainer>(this, 114, 27, 17, 14, 61, 130, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        textEnterButton.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorControlRodContainer)this.func_212873_a_()).executeRequest("setName", textBox.getContents());
            return true;
        };
        this.addElement((AbstractElement)textEnterButton);
        Button rodRetractButton = new Button((ScreenBase)this, 58, 82, 14, 15, 226, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_control_rod.retract_rod.tooltip"));
        rodRetractButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodRetractButton.func_231047_b_(mX, mY)) {
                double delta = Screen.func_231173_s_() && Screen.func_231172_r_() ? -100.0 : (Screen.func_231172_r_() ? -50.0 : (Screen.func_231173_s_() ? -10.0 : -1.0));
                ((ReactorControlRodContainer)this.func_212873_a_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.func_231174_t_()));
                rodRetractButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        rodRetractButton.onRender = (mS, mX, mY) -> {
            if (rodRetractButton.func_231047_b_((double)mX, (double)mY)) {
                rodRetractButton.blit(mS, 242, 0);
            } else {
                rodRetractButton.blit(mS, 228, 0);
            }
        };
        this.addElement((AbstractElement)rodRetractButton);
        Button rodInsertButton = new Button((ScreenBase)this, 58, 64, 14, 15, 226, 0, (ITextComponent)new TranslationTextComponent("screen.biggerreactors.reactor_control_rod.insert_rod.tooltip"));
        rodInsertButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodInsertButton.func_231047_b_(mX, mY)) {
                double delta = Screen.func_231173_s_() && Screen.func_231172_r_() ? 100.0 : (Screen.func_231172_r_() ? 50.0 : (Screen.func_231173_s_() ? 10.0 : 1.0));
                ((ReactorControlRodContainer)this.func_212873_a_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.func_231174_t_()));
                rodInsertButton.playSound(SoundEvents.field_187909_gi);
                return true;
            }
            return false;
        };
        rodInsertButton.onRender = (mS, mX, mY) -> {
            if (rodInsertButton.func_231047_b_((double)mX, (double)mY)) {
                rodInsertButton.blit(mS, 242, 15);
            } else {
                rodInsertButton.blit(mS, 228, 15);
            }
        };
        this.addElement((AbstractElement)rodInsertButton);
    }

    public void initGauges() {
        Symbol rodInsertionGauge = new Symbol((ScreenBase)this, 36, 50, 18, 64, 0, 126, StringTextComponent.field_240750_d_);
        rodInsertionGauge.onRender = (mS, mX, mY) -> ReactorControlRodScreen.renderInsertionLevel(mS, (Symbol<ReactorControlRodContainer>)rodInsertionGauge, this.reactorControlRodState.insertionLevel);
        this.addElement((AbstractElement)rodInsertionGauge);
    }

    public void func_230430_a_(@Nonnull MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_238421_b_(mStack, new TranslationTextComponent("screen.biggerreactors.reactor_control_rod.name").getString(), (float)(this.getGuiLeft() + 8), (float)(this.getGuiTop() + 17), 0x404040);
        this.field_230712_o_.func_238421_b_(mStack, String.format("%.1f%%", this.reactorControlRodState.insertionLevel), (float)(this.getGuiLeft() + 76), (float)(this.getGuiTop() + 77), 0x404040);
    }

    public static void renderInsertionLevel(@Nonnull MatrixStack mStack, @Nonnull Symbol<ReactorControlRodContainer> symbol, double insertionLevel) {
        RenderHelper.drawFluidGrid((MatrixStack)mStack, (int)(symbol.x + 1), (int)symbol.y, (int)symbol.getBlitOffset(), (int)16, (int)16, (Fluid)FluidYellorium.INSTANCE.func_210198_f(), (int)1, (int)4);
        if (insertionLevel > 0.0) {
            int renderSize = (int)((double)symbol.height * insertionLevel / 100.0);
            symbol.blit(mStack, symbol.width, renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(mStack);
        symbol.tooltip = new StringTextComponent(String.format("%.1f%%", insertionLevel));
    }
}

