/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.collection;

import java.util.List;
import java.util.Random;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.cache.FluidCache;
import quphoria.compactvoidminers.config.Config;

public class FluidCollection {
    public static Fluid collect(Random rand) {
        if (FluidCache.getFluids().size() == 0) {
            return null;
        }
        ResourceLocation fluidName = FluidCache.getFluids().get(rand.nextInt(FluidCache.getFluids().size()));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
        if (CompactVoidMiners.logCollection) {
            CompactVoidMiners.LOGGER.info("FLUIDNAME>>" + fluid.getRegistryName().toString());
        }
        return fluid;
    }

    protected static <T extends IForgeRegistryEntry<T>> T getRandomFromRegistry(IForgeRegistry<T> registry, Random rand) {
        ResourceLocation[] keys = registry.getKeys().toArray(new ResourceLocation[0]);
        int length = keys.length;
        if (length == 0) {
            return null;
        }
        int index = (int)Math.floor(rand.nextDouble() * (double)length);
        ResourceLocation key = keys[index];
        return (T)registry.getValue(key);
    }

    public static boolean checkBlacklist(ResourceLocation fluid) {
        String fluidName = fluid.toString();
        for (String key : (List)Config.voidpump.fluidPartialBlacklist.get()) {
            if (!fluidName.toLowerCase().contains(key.toLowerCase())) continue;
            return true;
        }
        for (String key : (List)Config.voidpump.fluidExactBlacklist.get()) {
            if (!fluidName.equals(key)) continue;
            return true;
        }
        return false;
    }
}

