/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks.voidpump;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import quphoria.compactvoidminers.blocks.TileEntityMachine;
import quphoria.compactvoidminers.blocks.voidpump.ContainerVoidPump;
import quphoria.compactvoidminers.collection.FluidCollection;
import quphoria.compactvoidminers.fluid.MultiFluidStorage;
import quphoria.compactvoidminers.init.ModTileEntityTypes;

public class TileEntityVoidPump
extends TileEntityMachine
implements IContainerListener {
    private MultiFluidStorage fluidTank = new MultiFluidStorage(10000, 10);
    private ItemStackHandler filterItem = new ItemStackHandler(1);
    private int collectionSourceID = 0;
    private int lastFluids = 0;
    private int lastFilterItem = 0;
    LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);

    public TileEntityVoidPump() {
        super((TileEntityType)ModTileEntityTypes.voidPumpTE.get());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("filterItem", (INBT)this.filterItem.serializeNBT());
        compound = this.fluidTank.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.filterItem.deserializeNBT(compound.func_74775_l("filterItem"));
        this.fluidTank.readFromNBT(compound);
        this.lastFluids = ((Object)((Object)this.fluidTank)).hashCode();
        this.lastFilterItem = this.filterItem.hashCode();
        super.func_230337_a_(state, compound);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != Direction.DOWN) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.filterItem);
        super.breakBlock(world, pos);
    }

    public IItemHandler getFilterInventory() {
        return this.filterItem;
    }

    @Override
    protected void calculateUpgrades() {
        this.collectionSourceID = 0;
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2453, -2544, 2789, -2212}))) > 0) {
            this.usedBefore = true;
            this.collectionSourceID = 1;
        }
        super.calculateUpgrades();
    }

    private boolean tankSpace() {
        return this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity();
    }

    @Override
    protected boolean canRun() {
        return super.canRun() && this.tankSpace();
    }

    @Override
    protected boolean runMachine() {
        return this.collectFluid();
    }

    public int getFluidLevel() {
        return this.fluidTank.getFluidAmount();
    }

    public int getMaxFluidLevel() {
        return this.fluidTank.getCapacity();
    }

    @Override
    protected boolean hasFilterItem() {
        return this.getFilterFluid() != null;
    }

    @Override
    public void func_73660_a() {
        if (this.lastFluids != ((Object)((Object)this.fluidTank)).hashCode() || this.lastFilterItem != this.filterItem.hashCode()) {
            this.shouldUpdate = true;
        }
        super.func_73660_a();
    }

    private boolean collectFluid() {
        switch (this.collectionSourceID) {
            case 0: {
                Fluid fluid = FluidCollection.collect(this.rand);
                if (fluid == null) {
                    return false;
                }
                FluidStack stack = new FluidStack(fluid, 1000);
                return this.attemptInsert(stack);
            }
            case 1: {
                Fluid fluid = this.getFilterFluid();
                if (fluid == null) {
                    return false;
                }
                FluidStack stack = new FluidStack(fluid, 1000);
                return this.attemptInsert(stack);
            }
        }
        return false;
    }

    private Fluid getFilterFluid() {
        ItemStack filterStack = this.filterItem.getStackInSlot(0);
        Item filterI = filterStack.func_77973_b();
        if (!(filterI instanceof BucketItem)) {
            return null;
        }
        BucketItem filter = (BucketItem)filterI;
        return filter.getFluid();
    }

    public int getFluidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public List<FluidStack> getFluids() {
        return this.fluidTank.getFluids();
    }

    public ItemStack getFluidBucket(FluidStack targetFluid) {
        return this.fluidTank.getFluidBucket(targetFluid);
    }

    private boolean attemptInsert(FluidStack stack) {
        if (this.getFilterFluid() == null || !this.hasFilterUpgrade()) {
            return this.fluidTank.fillInternal(stack, true) > 0;
        }
        if (this.getFilterFluid() == stack.getFluid()) {
            return this.fluidTank.fillInternal(stack, true) > 0;
        }
        return true;
    }

    public void getFluidBucket(FluidStack fluid, ServerPlayerEntity player) {
        ItemStack fluidBucket;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation("bucket"))) && !(fluidBucket = this.getFluidBucket(fluid)).func_190926_b()) {
            if (heldItem.func_190916_E() == 1) {
                heldItem = fluidBucket;
                player.field_71071_by.func_70437_b(heldItem);
            } else {
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                player.field_71071_by.func_70437_b(heldItem);
                if (!player.field_71071_by.func_70441_a(fluidBucket)) {
                    player.func_146097_a(fluidBucket, false, true);
                }
            }
            this.setBlockToUpdate();
            player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, heldItem));
        }
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        this.shouldUpdate = true;
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public void func_174888_l() {
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.compactvoidminers.void_pump");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new ContainerVoidPump(id, playerInventory, this);
    }
}

