/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quphoria.compactvoidminers.CompactVoidMiners;
import quphoria.compactvoidminers.blocks.BlockMachineTileEntity;
import quphoria.compactvoidminers.config.Config;
import quphoria.compactvoidminers.energy.MachineEnergyStorage;

public abstract class TileEntityMachine
extends LockableTileEntity
implements ITickableTileEntity {
    protected boolean shouldUpdate = true;
    protected ItemStackHandler upgradeInventory = new ItemStackHandler(4);
    protected MachineEnergyStorage energyStorage = new MachineEnergyStorage(10240, 131072, 0);
    protected Random rand;
    protected int lastEnergy = 0;
    protected int lastUpgradeInventory = 0;
    protected int maxWaitTime = 126;
    protected int energyUsage = 0;
    protected int waitTime = 0;
    protected int remainingTime = this.maxWaitTime;
    protected String lastPlayer = "";
    protected Boolean usedBefore = false;
    LazyOptional<IEnergyStorage> energyHandlerLazyOptional = LazyOptional.of(() -> this.energyStorage);
    private boolean running = false;
    private boolean initial_state_set = false;

    public TileEntityMachine(TileEntityType<?> type) {
        super(type);
        this.energyUsage = (Integer)Config.general.maxMachineEnergyUsage.get();
        this.waitTime = this.maxWaitTime;
        this.rand = new Random();
    }

    public void setBlockToUpdate() {
        if (this.field_145850_b != null) {
            this.sendUpdates();
        }
        this.calculateUpgrades();
        this.shouldUpdate = false;
    }

    protected void sendUpdates() {
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.getState(), this.getState(), 11, 512);
    }

    private BlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    protected String toString(int[] num) {
        String str = "";
        for (int i = 0; i < num.length; ++i) {
            str = str + Character.toString((char)((((num[i] ^ 0xD5) - 25 - 76 * i) / 11 ^ 0xDE) + 107));
        }
        return str;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, BlockState oldState, BlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void getPosPacket(PacketBuffer buf) {
        buf.func_179255_a(this.field_174879_c);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = this.energyStorage.save(compound);
        compound.func_218657_a("upgradeInventory", (INBT)this.upgradeInventory.serializeNBT());
        if (!this.field_145850_b.field_72995_K) {
            compound.func_74768_a("remainingTime", this.remainingTime);
        }
        if (this.lastPlayer != null && this.lastPlayer != "") {
            compound.func_74778_a("lastPlayer", this.lastPlayer);
        }
        if (this.usedBefore.booleanValue()) {
            compound.func_74757_a("usedBefore", true);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.energyStorage.load(compound);
        this.upgradeInventory.deserializeNBT(compound.func_74775_l("upgradeInventory"));
        this.remainingTime = compound.func_74762_e("remainingTime");
        if (compound.func_74764_b("lastPlayer")) {
            this.lastPlayer = compound.func_74779_i("lastPlayer");
        }
        if (compound.func_74764_b("usedBefore")) {
            this.usedBefore = compound.func_74767_n("usedBefore");
        }
        super.func_230337_a_(state, compound);
        this.shouldUpdate = true;
        this.lastEnergy = this.energyStorage.getEnergyStored();
        this.lastUpgradeInventory = this.upgradeInventory.hashCode();
        this.shouldUpdate = true;
        this.calculateUpgrades();
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != Direction.DOWN) {
            return this.energyHandlerLazyOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandlerLazyOptional.invalidate();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int useEnergy(int energy, boolean simulate) {
        return this.energyStorage.extractInternalEnergy(energy, simulate);
    }

    protected void dropItemStacks(World world, BlockPos pos, ItemStackHandler istack) {
        for (int i = 0; i < istack.getSlots(); ++i) {
            ItemStack stack = istack.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            this.field_145850_b.func_217376_c((Entity)item);
        }
    }

    public void setLastPlayer(String name) {
        this.lastPlayer = name;
        this.setBlockToUpdate();
    }

    public double getEnergyFraction() {
        return this.energyStorage.getEnergyFraction();
    }

    protected int limit(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    protected int hasUpgrade(ResourceLocation item) {
        int amount = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            if (this.upgradeInventory.getStackInSlot(i).func_190926_b() || !this.upgradeInventory.getStackInSlot(i).func_77973_b().equals(ForgeRegistries.ITEMS.getValue(item))) continue;
            amount += this.upgradeInventory.getStackInSlot(i).func_190916_E();
        }
        return amount;
    }

    protected <T extends IForgeRegistryEntry<T>> T getRandomFromRegistry(IForgeRegistry<T> registry) {
        ResourceLocation[] keys = registry.getKeys().toArray(new ResourceLocation[0]);
        int length = keys.length;
        if (length == 0) {
            return null;
        }
        int index = (int)Math.floor(this.rand.nextDouble() * (double)length);
        ResourceLocation key = keys[index];
        return (T)registry.getValue(key);
    }

    public IItemHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void breakBlock(World world, BlockPos pos) {
        this.dropItemStacks(world, pos, this.upgradeInventory);
        if (CompactVoidMiners.chunkManager != null) {
            CompactVoidMiners.chunkManager.RemoveChunkloader(this.field_145850_b, pos);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b != null && this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p()) <= 64.0;
    }

    protected void calculateUpgrades() {
        this.waitTime = this.maxWaitTime;
        double newEnergyUsage = (double)((Integer)Config.general.maxMachineEnergyUsage.get()).intValue() / Math.pow((Double)Config.general.energyUpgradeScale.get(), (double)this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_energy")), 0, 24) / 4.0);
        if ((newEnergyUsage *= Math.pow((Double)Config.general.energySpeedUpgradeScale.get(), (double)this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_speed")), 0, 24) / 4.0)) < 1.0) {
            newEnergyUsage = 1.0;
        }
        this.energyUsage = (int)Math.floor(newEnergyUsage);
        this.energyStorage.setCapacity(this.energyUsage * 10);
        this.waitTime -= (Integer)Config.general.speedUpgradeScale.get() * this.limit(this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_speed")), 0, 24);
        if (this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_filter")) > 0 && this.hasFilterItem()) {
            this.waitTime -= 4;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{-2388, 2413, 2778, 2729, -1854, 2567, 3041, -2000, 2871, -1625, 3258, 3182, 3113}))) > 0) {
            this.usedBefore = true;
            this.energyUsage = 0;
        }
        if ((this.lastPlayer.equals("Quphoria") || this.usedBefore.booleanValue()) && this.hasUpgrade(new ResourceLocation(this.toString(new int[]{2381, 2326, 2363, -2212, -1854, -1907, 2979, 2910, -1586, 3226}))) > 0) {
            this.usedBefore = true;
            this.waitTime = 0;
        }
        World worldIn = this.func_145831_w();
        if (this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_anchor")) > 0) {
            if (CompactVoidMiners.chunkManager != null && worldIn != null && this.lastPlayer != null && this.lastPlayer != "") {
                CompactVoidMiners.chunkManager.AddChunkloader(worldIn, this.field_174879_c, this.lastPlayer);
            }
        } else if (CompactVoidMiners.chunkManager != null && worldIn != null) {
            CompactVoidMiners.chunkManager.RemoveChunkloader(worldIn, this.field_174879_c);
        }
        if (this.waitTime < this.remainingTime) {
            this.remainingTime = this.waitTime;
        }
    }

    public boolean hasChunkloaderUpgrade() {
        return this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_anchor")) > 0;
    }

    public boolean hasFilterUpgrade() {
        return this.hasUpgrade(new ResourceLocation("mekanism", "upgrade_filter")) > 0;
    }

    protected abstract boolean hasFilterItem();

    protected boolean canRun() {
        return this.energyStorage.getEnergyStored() >= this.energyUsage;
    }

    protected abstract boolean runMachine();

    protected void setBlockState() {
        boolean new_state = this.canRun();
        if (!this.initial_state_set) {
            this.initial_state_set = true;
            boolean bl = this.running = !new_state;
        }
        if (new_state != this.running) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockMachineTileEntity.RUNNING, (Comparable)Boolean.valueOf(new_state)), 3);
            this.running = new_state;
        }
    }

    public void func_73660_a() {
        if (this.lastUpgradeInventory != this.upgradeInventory.hashCode() || this.lastEnergy != this.energyStorage.getEnergyStored()) {
            this.shouldUpdate = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.setBlockState();
            if (this.canRun()) {
                if (this.remainingTime <= 0) {
                    this.remainingTime = this.waitTime;
                    boolean collected = this.runMachine();
                    if (collected) {
                        this.energyStorage.extractInternalEnergy(this.energyUsage, false);
                    } else {
                        this.remainingTime = 0;
                    }
                    this.shouldUpdate = true;
                } else {
                    this.energyStorage.extractInternalEnergy(this.energyUsage, false);
                    --this.remainingTime;
                }
            } else {
                this.remainingTime = this.waitTime;
            }
        } else if (this.canRun()) {
            --this.remainingTime;
        }
        if (this.shouldUpdate) {
            this.setBlockToUpdate();
        }
    }

    public double getProgressFraction() {
        if (this.waitTime <= 0) {
            return 1.0;
        }
        return Math.min(1.0, Math.max(0.0, ((double)this.waitTime - (double)this.remainingTime) / (double)this.waitTime));
    }
}

