/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import quphoria.compactvoidminers.blocks.ContainerMachine;
import quphoria.compactvoidminers.blocks.TileEntityMachine;

public abstract class ScreenMachine<T extends ContainerMachine<?>>
extends ContainerScreen<T> {
    protected ContainerMachine<?> container;
    protected PlayerInventory playerInv;
    protected ResourceLocation BG_TEXTURE;
    protected Rectangle energyBar = new Rectangle(0, 0, 0, 0);
    protected Rectangle progressBar = new Rectangle(0, 0, 0, 0);
    protected int energyBarTextureX = 0;
    protected int energyBarTextureY = 0;
    protected int progressBarTextureX = 0;
    protected int progressBarTextureY = 0;

    public ScreenMachine(T container, PlayerInventory playerInv, ITextComponent title) {
        super(container, playerInv, title);
        this.container = container;
        this.playerInv = playerInv;
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.BG_TEXTURE);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.container.tileEntity != null) {
            int energy_level = (int)Math.round((double)this.energyBar.width * ((TileEntityMachine)((Object)this.container.tileEntity)).getEnergyFraction());
            this.func_238474_b_(matrix, x + this.energyBar.x, y + this.energyBar.y, this.energyBarTextureX, this.energyBarTextureY, energy_level, this.energyBar.height);
            int progress_level = (int)Math.round((double)this.progressBar.width * ((TileEntityMachine)((Object)this.container.tileEntity)).getProgressFraction());
            this.func_238474_b_(matrix, x + this.progressBar.x, y + this.progressBar.y, this.progressBarTextureX, this.progressBarTextureY, progress_level, this.progressBar.height);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        super.func_230451_b_(matrix, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        this.drawTooltips(tooltip, mouseX, mouseY);
        if (!tooltip.isEmpty()) {
            this.func_243308_b(matrix, tooltip, mouseX, mouseY);
        } else {
            this.func_230459_a_(matrix, mouseX, mouseY);
        }
    }

    protected String addDigitGrouping(int number) {
        String output = Integer.toString(number);
        for (int i = output.length() - 3; i > 0; i -= 3) {
            output = output.substring(0, i) + "," + output.substring(i);
        }
        return output;
    }

    protected void drawTooltips(List<ITextComponent> tooltip, int mouseX, int mouseY) {
        if (this.container.tileEntity != null) {
            if (this.energyBar.contains(mouseX, mouseY)) {
                tooltip.add((ITextComponent)new StringTextComponent("Energy: " + this.addDigitGrouping(((TileEntityMachine)((Object)this.container.tileEntity)).getEnergy()) + " RF"));
                tooltip.add((ITextComponent)new StringTextComponent("Max: " + this.addDigitGrouping(((TileEntityMachine)((Object)this.container.tileEntity)).getMaxEnergy()) + " RF"));
            }
            if (this.progressBar.contains(mouseX, mouseY)) {
                tooltip.add((ITextComponent)new StringTextComponent("Progress: " + (int)Math.round(100.0 * ((TileEntityMachine)((Object)this.container.tileEntity)).getProgressFraction()) + "%"));
            }
        }
    }
}

