/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedSelector<T> {
    private final List<WeightedEntry<T>> entries = new ArrayList<WeightedEntry<T>>();
    private int total = 0;

    public boolean addEntry(T value, int weight) {
        return this.addEntry(new WeightedEntry<T>(value, weight));
    }

    public boolean addEntry(WeightedEntry<T> entry) {
        boolean added = this.entries.add(entry);
        if (added) {
            this.total += entry.getWeight();
        }
        return added;
    }

    public boolean removeEntry(WeightedEntry<T> entry) {
        boolean removed = this.entries.remove(entry);
        if (removed) {
            this.total -= entry.getWeight();
        }
        return removed;
    }

    public List<WeightedEntry<T>> getEntries() {
        return this.entries;
    }

    @Nullable
    public WeightedEntry<T> getRandomEntry(Random rand) {
        if (!this.entries.isEmpty()) {
            int selected = rand.nextInt(this.total);
            int current = 0;
            for (WeightedEntry<T> entry : this.entries) {
                if (selected >= (current += ((WeightedEntry)entry).weight)) continue;
                return entry;
            }
        }
        return null;
    }

    public int getTotalWeight() {
        return this.total;
    }

    public int updateTotal() {
        this.total = 0;
        for (WeightedEntry<T> entry : this.entries) {
            this.total += entry.getWeight();
        }
        return this.total;
    }

    public static class WeightedEntry<T> {
        private final T entry;
        private final int weight;

        public WeightedEntry(T entry, int weight) {
            this.entry = entry;
            this.weight = weight;
        }

        public T getEntry() {
            return this.entry;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

