/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;

public class Util {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readResourceLocation(ResourceLocation location) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_195551_G().func_199002_a(location).func_199027_b()));){
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static JsonObject readJSONFile(ResourceLocation location) {
        String jsonString;
        if (location.func_110623_a().lastIndexOf(".json") != location.func_110623_a().length() - 5) {
            location = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        }
        if ((jsonString = Util.readResourceLocation(location)) == null) {
            return null;
        }
        JsonElement element = new JsonParser().parse(jsonString);
        if (element instanceof JsonObject) {
            return (JsonObject)element;
        }
        return null;
    }

    public static void chunkCachedBlockStateIteration(Vector3ic start, Vector3ic end, World world, BiConsumer<BlockState, Vector3i> func) {
        Util.chunkCachedBlockStateIteration(start, end, world, func, new Vector3i());
    }

    public static void chunkCachedBlockStateIteration(Vector3ic start, Vector3ic end, World world, BiConsumer<BlockState, Vector3i> func, Vector3i scratchVector) {
        for (int X = start.x(); X < (end.x() + 16 & 0xFFFFFFF0); X += 16) {
            for (int Z = start.z(); Z < (end.z() + 16 & 0xFFFFFFF0); Z += 16) {
                int chunkX = X >> 4;
                int chunkZ = Z >> 4;
                Chunk chunk = (Chunk)world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false);
                ChunkSection[] chunkSections = chunk != null ? chunk.func_76587_i() : null;
                for (int Y = start.y(); Y < (end.y() + 16 & 0xFFFFFFF0); Y += 16) {
                    int chunkSectionIndex = Y >> 4;
                    ChunkSection chunkSection = chunkSections != null ? chunkSections[chunkSectionIndex] : null;
                    int sectionMinX = Math.max(X & 0xFFFFFFF0, start.x());
                    int sectionMinY = Math.max(Y & 0xFFFFFFF0, start.y());
                    int sectionMinZ = Math.max(Z & 0xFFFFFFF0, start.z());
                    int sectionMaxX = Math.min(X + 16 & 0xFFFFFFF0, end.x() + 1);
                    int sectionMaxY = Math.min(Y + 16 & 0xFFFFFFF0, end.y() + 1);
                    int sectionMaxZ = Math.min(Z + 16 & 0xFFFFFFF0, end.z() + 1);
                    for (int x = sectionMinX; x < sectionMaxX; ++x) {
                        for (int y = sectionMinY; y < sectionMaxY; ++y) {
                            for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                                scratchVector.set(x, y, z);
                                BlockState state = Blocks.field_150350_a.func_176223_P();
                                if (chunkSection != null) {
                                    state = chunkSection.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                                }
                                func.accept(state, scratchVector);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void markRangeDirty(World world, Vector2i start, Vector2i end) {
        for (int X = start.x; X < (end.x + 16 & 0xFFFFFFF0); X += 16) {
            for (int Z = start.y; Z < (end.y + 16 & 0xFFFFFFF0); Z += 16) {
                int chunkX = X >> 4;
                int chunkZ = Z >> 4;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                chunk.func_76630_e();
            }
        }
    }

    public static void setBlockStates(Map<BlockPos, BlockState> newStates, World world) {
        HashMap<BlockPos, HashMap> stateChunks = new HashMap<BlockPos, HashMap>();
        BlockPos.Mutable chunkPos = new BlockPos.Mutable();
        newStates.forEach((pos, state) -> {
            chunkPos.func_181079_c(pos.func_177958_n() >> 4, 0, pos.func_177952_p() >> 4);
            HashMap<BlockPos, BlockState> chunksNewStates = (HashMap<BlockPos, BlockState>)stateChunks.get(chunkPos);
            if (chunksNewStates == null) {
                chunksNewStates = new HashMap<BlockPos, BlockState>();
                stateChunks.put(chunkPos.func_185334_h(), chunksNewStates);
            }
            chunksNewStates.put((BlockPos)pos, (BlockState)state);
        });
        stateChunks.forEach((cPos, states) -> {
            Chunk chunk = world.func_212866_a_(cPos.func_177958_n(), cPos.func_177952_p());
            ChunkSection[] chunkSections = chunk.func_76587_i();
            states.forEach((bPos, state) -> {
                ChunkSection section = chunkSections[bPos.func_177956_o() >> 4];
                if (section != null) {
                    BlockState oldState = section.func_222629_a(bPos.func_177958_n() & 0xF, bPos.func_177956_o() & 0xF, bPos.func_177952_p() & 0xF, state);
                    world.func_184138_a(bPos, oldState, state, 0);
                }
            });
            chunk.func_76630_e();
        });
    }

    public static Direction directionFromPositions(BlockPos reference, BlockPos neighbor) {
        int xDifference = reference.func_177958_n() - neighbor.func_177958_n();
        int yDifference = reference.func_177956_o() - neighbor.func_177956_o();
        int zDifference = reference.func_177952_p() - neighbor.func_177952_p();
        if (Math.abs(xDifference) + Math.abs(yDifference) + Math.abs(zDifference) > 1) {
            throw new IllegalArgumentException("positions not neighbors");
        }
        if (xDifference == -1) {
            return Direction.WEST;
        }
        if (xDifference == 1) {
            return Direction.EAST;
        }
        if (yDifference == -1) {
            return Direction.DOWN;
        }
        if (yDifference == 1) {
            return Direction.UP;
        }
        if (zDifference == -1) {
            return Direction.NORTH;
        }
        if (zDifference == 1) {
            return Direction.SOUTH;
        }
        throw new IllegalArgumentException("identical positions gives");
    }
}

