/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AStarList {
    TreeSet<BlockPos> targets = new TreeSet(this::orderingFunction);
    TreeSet<BlockPos> nodeSet = new TreeSet(this::orderingFunction);

    private int orderingFunction(BlockPos a, BlockPos b) {
        if (this.targets.isEmpty()) {
            return 0;
        }
        BlockPos target = this.targets.first();
        double aDistance = a.func_177951_i((Vector3i)target);
        double bDistance = b.func_177951_i((Vector3i)target);
        int aHash = a.hashCode();
        int bHash = b.hashCode();
        return aDistance < bDistance ? -1 : (bDistance == aDistance ? Integer.compare(aHash, bHash) : 1);
    }

    public void addTarget(BlockPos target) {
        if (this.targets.isEmpty()) {
            this.nodeSet.add(target);
        }
        this.targets.add(target);
    }

    public void addNode(BlockPos node) {
        this.targets.remove(node);
        this.nodeSet.add(node);
    }

    public BlockPos nextNode() {
        return Objects.requireNonNull(this.nodeSet.pollFirst());
    }

    public boolean done() {
        return this.targets.isEmpty() || this.nodeSet.isEmpty();
    }

    public boolean foundAll() {
        return this.targets.isEmpty();
    }
}

